package com.segway.robot.sdk.vision.calibration;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.Arrays;

/**
 * Video stream intrinsics
 * Created by gaofeng on 2018/3/15.
 */

public class RS2Intrinsic implements Parcelable {

    /**
     * Width of the image in pixels
     */
    private int width;

    /**
     * Height of the image in pixels
     */
    private int height;

    /**
     * Horizontal coordinate of the principal point of the image, as a pixel offset from the left edge
     */
    private float principalPointX;

    /**
     * Vertical coordinate of the principal point of the image, as a pixel offset from the top edge
     */
    private float principalPointY;

    /**
     * Focal length of the image plane, as a multiple of pixel width
     */
    private float focalLengthX;

    /**
     * Focal length of the image plane, as a multiple of pixel height
     */
    private float focalLengthY;

    /**
     * Distortion model of the image, {@link RS2Distortion}
     */
    private int rs2distortion;

    /**
     * Distortion coefficients
     */
    private float[] coeffs;

    public RS2Intrinsic() {
    }

    public RS2Intrinsic(int width, int height, float principalPointX, float principalPointY, float focalLengthX, float focalLengthY, int rs2distortion, float[] coeffs) {
        this.width = width;
        this.height = height;
        this.principalPointX = principalPointX;
        this.principalPointY = principalPointY;
        this.focalLengthX = focalLengthX;
        this.focalLengthY = focalLengthY;
        this.rs2distortion = rs2distortion;
        this.coeffs = coeffs;
    }

    protected RS2Intrinsic(Parcel in) {
        width = in.readInt();
        height = in.readInt();
        principalPointX = in.readFloat();
        principalPointY = in.readFloat();
        focalLengthX = in.readFloat();
        focalLengthY = in.readFloat();
        rs2distortion = in.readInt();
        coeffs = in.createFloatArray();
    }

    public static final Creator<RS2Intrinsic> CREATOR = new Creator<RS2Intrinsic>() {
        @Override
        public RS2Intrinsic createFromParcel(Parcel in) {
            return new RS2Intrinsic(in);
        }

        @Override
        public RS2Intrinsic[] newArray(int size) {
            return new RS2Intrinsic[size];
        }
    };

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public float getPrincipalPointX() {
        return principalPointX;
    }

    public void setPrincipalPointX(float principalPointX) {
        this.principalPointX = principalPointX;
    }

    public float getPrincipalPointY() {
        return principalPointY;
    }

    public void setPrincipalPointY(float principalPointY) {
        this.principalPointY = principalPointY;
    }

    public float getFocalLengthX() {
        return focalLengthX;
    }

    public void setFocalLengthX(float focalLengthX) {
        this.focalLengthX = focalLengthX;
    }

    public float getFocalLengthY() {
        return focalLengthY;
    }

    public void setFocalLengthY(float focalLengthY) {
        this.focalLengthY = focalLengthY;
    }

    public int getRs2distortion() {
        return rs2distortion;
    }

    public void setRs2distortion(int rs2distortion) {
        this.rs2distortion = rs2distortion;
    }

    public float[] getCoeffs() {
        return coeffs;
    }

    public void setCoeffs(float[] coeffs) {
        this.coeffs = coeffs;
    }

    @Override
    public String toString() {
        return "RS2Intrinsic{" +
                "width=" + width +
                ", height=" + height +
                ", principalPointX=" + principalPointX +
                ", principalPointY=" + principalPointY +
                ", focalLengthX=" + focalLengthX +
                ", focalLengthY=" + focalLengthY +
                ", rs2distortion=" + rs2distortion +
                ", coeffs=" + Arrays.toString(coeffs) +
                "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(width);
        dest.writeInt(height);
        dest.writeFloat(principalPointX);
        dest.writeFloat(principalPointY);
        dest.writeFloat(focalLengthX);
        dest.writeFloat(focalLengthY);
        dest.writeInt(rs2distortion);
        dest.writeFloatArray(coeffs);
    }

    public void readFromParcel(Parcel in) {
        width = in.readInt();
        height = in.readInt();
        principalPointX = in.readFloat();
        principalPointY = in.readFloat();
        focalLengthX = in.readFloat();
        focalLengthY = in.readFloat();
        rs2distortion = in.readInt();
        in.readFloatArray(coeffs);
    }
}
