package com.segway.robot.sdk.vision.tools;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Data with confidence
 */
public class DataWithConfidence<T> implements Parcelable {
    /**
     * confidence
     */
    public float confidence;

    /**
     * data
     */
    public Parcelable data;

    /**
     * Constructor
     * @param data data
     * @param confidence confidence
     */
    public DataWithConfidence(Parcelable data, float confidence) {
        this.confidence = confidence;
        this.data = data;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(confidence);
        dest.writeParcelable(data,flags);
    }

    /**
     * used by Parcel
     */
    public static final Creator<DataWithConfidence> CREATOR = new Creator<DataWithConfidence>() {
        @Override
        public DataWithConfidence createFromParcel(Parcel source) {
            float confidence = source.readFloat();
            Parcelable data = source.readParcelable(getClass().getClassLoader());
            return new DataWithConfidence(data, confidence);
        }

        @Override
        public DataWithConfidence[] newArray(int size) {
            return new DataWithConfidence[size];
        }
    };
}
