package com.segway.robot.sdk.vision.calibration;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Brief distortion model, defines how pixel coordinates should be mapped to sensor coordinates.
 * Created by gaofeng on 2018/3/15.
 */

public interface RS2Distortion {

    /**
     * Rectilinear images. No distortion compensation required.
     */
    int NONE = 0;
    /**
     * Equivalent to Brown-Conrady distortion, except that tangential distortion is applied to radially distorted points
     */
    int MODIFIED_BROWN_CONRADY = 1;

    /**
     * Equivalent to Brown-Conrady distortion, except undistorts image
     * instead of distorting it
     */
    int INVERSE_BROWN_CONRADY = 2;

    /**
     * F-Theta fish-eye distortion model
     */
    int F_THETA = 3;

    /**
     * Unmodified Brown-Conrady distortion model
     */
    int BROWN_CONRADY = 4;

    /**
     * Number of enumeration values. Not a valid input: intended to be used in for-loops.
     */
    int COUNT = 5;

    @IntDef({NONE, MODIFIED_BROWN_CONRADY, INVERSE_BROWN_CONRADY, F_THETA, BROWN_CONRADY, COUNT})

    @Retention(RetentionPolicy.SOURCE)
    @interface RS2DistortionTag {
    }
}
