package com.segway.robot.sdk.vision.stream;

import com.segway.robot.sdk.base.log.Logger;

/**
 * Created by gaofeng on 2018/3/15.
 */

public class ExtDepthStreamFactory {
    private static final String TAG = "ExtDepthStreamFactory";

    public static StreamInfo createExtDepthConfig(@ExtDepthStreamConfig.ExtDepthStream int config,
                                                  @StreamType.VisionStreamTypeAdvanced int type) {
        if (type != StreamType.EXT_DEPTH_R && type != StreamType.EXT_DEPTH_L) {
            Logger.e(TAG,"ext depth stream type is illegal!");
            throw new IllegalArgumentException("ext depth stream type is illegal!");
        }

        switch (config) {
            case ExtDepthStreamConfig.CONFIG_424_240_30FPS:
                return StreamInfo.create(type, Resolution.Depth.R_424_240, FrameRate.FPS_30, PixelFormat.Z16);
            case ExtDepthStreamConfig.CONFIG_424_240_15FPS:
                return StreamInfo.create(type, Resolution.Depth.R_424_240, FrameRate.FPS_15, PixelFormat.Z16);
            case ExtDepthStreamConfig.CONFIG_424_240_6FPS:
                return StreamInfo.create(type, Resolution.Depth.R_424_240, FrameRate.FPS_6, PixelFormat.Z16);
            case ExtDepthStreamConfig.CONFIG_480_270_30FPS:
                return StreamInfo.create(type, Resolution.Depth.R_480_270, FrameRate.FPS_30, PixelFormat.Z16);
            case ExtDepthStreamConfig.CONFIG_480_270_15FPS:
                return StreamInfo.create(type, Resolution.Depth.R_480_270, FrameRate.FPS_15, PixelFormat.Z16);
            case ExtDepthStreamConfig.CONFIG_480_270_6FPS:
                return StreamInfo.create(type, Resolution.Depth.R_480_270, FrameRate.FPS_6, PixelFormat.Z16);
            case ExtDepthStreamConfig.CONFIG_628_468_6FPS:
                return StreamInfo.create(type,Resolution.Depth.R_628_468,FrameRate.FPS_6,PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_1280_720_6FPS:
                return StreamInfo.create(type,Resolution.Depth.R_1280_720,FrameRate.FPS_6,PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_NONE:
                Logger.w(TAG, "createExtDepthConfig: CONFIG_NONE is not supported now!");
                return null;
            default:
                Logger.w(TAG, "createExtDepthConfig: none config");
                return null;
        }
    }

    public static StreamInfo createExtIRConfig(@ExtDepthStreamConfig.ExtDepthStream int config,
                                               @StreamType.VisionStreamTypeAdvanced int type) {
        if (type != StreamType.EXT_IR_L && type != StreamType.EXT_IR_R) {
            Logger.e(TAG,"ext IR stream type is illegal.");
            throw new IllegalArgumentException("ext IR stream type is illegal!");
        }

        switch (config) {
            case ExtDepthStreamConfig.CONFIG_424_240_30FPS:
                return StreamInfo.create(type, Resolution.Depth.R_424_240, FrameRate.FPS_30, PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_424_240_15FPS:
                return StreamInfo.create(type, Resolution.Depth.R_424_240, FrameRate.FPS_15, PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_424_240_6FPS:
                return StreamInfo.create(type, Resolution.Depth.R_424_240, FrameRate.FPS_6, PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_480_270_30FPS:
                return StreamInfo.create(type, Resolution.Depth.R_480_270, FrameRate.FPS_30, PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_480_270_15FPS:
                return StreamInfo.create(type, Resolution.Depth.R_480_270, FrameRate.FPS_15, PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_480_270_6FPS:
                return StreamInfo.create(type, Resolution.Depth.R_480_270, FrameRate.FPS_6, PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_628_468_6FPS:
                return StreamInfo.create(type,Resolution.Depth.R_628_468, FrameRate.FPS_6,PixelFormat.A8);
            case ExtDepthStreamConfig.CONFIG_NONE:
                Logger.w(TAG, "createExtDepthConfig: CONFIG_NONE is not supported now!");
                return null;
            default:
                Logger.w(TAG, "createExtDepthConfig: none config");
                return null;
        }
    }
}
