/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.framebuffer;

import android.util.SparseArray;
import com.segway.robot.sdk.base.time.StampedData;
import com.segway.robot.sdk.vision.frame.FrameInfo;
import com.segway.robot.sdk.vision.internal.framebuffer.BaseFrame;
import java.nio.ByteBuffer;
import java.util.Stack;

public class RecyclableFrame
extends BaseFrame {
    static SparseArray<Stack<RecyclableFrame>> mFramePool = new SparseArray();
    ByteBuffer mByteBuffer;
    FrameInfo mFrameInfo;
    private int mBufferSize;

    private RecyclableFrame(int bufferSize, FrameInfo frameInfo) {
        this.mBufferSize = bufferSize;
        this.mFrameInfo = frameInfo;
        this.mByteBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public void reuse(FrameInfo frameInfo) {
        super.reuse();
        this.mFrameInfo = frameInfo;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.mByteBuffer.rewind();
        return this.mByteBuffer;
    }

    @Override
    public FrameInfo getInfo() {
        return this.mFrameInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Class<RecyclableFrame> clazz = RecyclableFrame.class;
        synchronized (RecyclableFrame.class) {
            super.release();
            ((Stack)mFramePool.get(this.mBufferSize)).push(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized RecyclableFrame create(int bufferSize, FrameInfo frameInfo) {
        if (mFramePool.get(bufferSize) == null) {
            mFramePool.put(bufferSize, new Stack());
        }
        if (((Stack)mFramePool.get(bufferSize)).empty()) {
            return new RecyclableFrame(bufferSize, frameInfo);
        }
        RecyclableFrame recyclableFrame = (RecyclableFrame)((Stack)mFramePool.get(bufferSize)).pop();
        recyclableFrame.reuse(frameInfo);
        return recyclableFrame;
    }

    public long getTimestamp() {
        return this.mFrameInfo.getIMUTimeStamp();
    }

    public long diff(StampedData source) {
        return source.getTimestamp() - this.getTimestamp();
    }
}

