/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.ipc;

import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.internal.ipc.MemoryFileUtil;
import java.io.IOException;

public class MemoryFileBuffer
implements Parcelable {
    private static final String TAG = "MemoryFileBuffer";
    static int seed = 0;
    static ClassLoader mParcelFileDescriptorClassLoader = ParcelFileDescriptor.class.getClassLoader();
    private MemoryFile mImageMemoryFile;
    private int mImageSize;
    private int mIndex;
    private int mInfoSize;
    private MemoryFile mInfoMemoryFile;
    private ParcelFileDescriptor mImageFD;
    private ParcelFileDescriptor mInfoFD;
    private boolean isDirty;
    public static final Parcelable.Creator<MemoryFileBuffer> CREATOR = new Parcelable.Creator<MemoryFileBuffer>(){

        public MemoryFileBuffer createFromParcel(Parcel in) {
            return new MemoryFileBuffer(in);
        }

        public MemoryFileBuffer[] newArray(int size) {
            return new MemoryFileBuffer[size];
        }
    };

    public MemoryFileBuffer(int size, int index) throws IOException {
        this.mImageSize = size;
        this.mIndex = index;
        this.mInfoSize = 60;
        this.mImageMemoryFile = new MemoryFile("segway.vision.image." + seed, size);
        this.mInfoMemoryFile = new MemoryFile("segway.vision.info." + seed++, this.mInfoSize);
        this.mImageMemoryFile.allowPurging(false);
        this.mInfoMemoryFile.allowPurging(false);
        this.mImageFD = MemoryFileUtil.createParcelFileDescriptor(MemoryFileUtil.getFileDescriptor(this.mImageMemoryFile));
        this.mInfoFD = MemoryFileUtil.createParcelFileDescriptor(MemoryFileUtil.getFileDescriptor(this.mInfoMemoryFile));
    }

    protected MemoryFileBuffer(Parcel in) {
        this.mImageFD = (ParcelFileDescriptor)in.readParcelable(mParcelFileDescriptorClassLoader);
        this.mInfoFD = (ParcelFileDescriptor)in.readParcelable(mParcelFileDescriptorClassLoader);
        this.mImageSize = in.readInt();
        this.mInfoSize = in.readInt();
        this.mIndex = in.readInt();
    }

    public MemoryFile getImageMemoryFile() {
        return this.mImageMemoryFile;
    }

    public ParcelFileDescriptor getImageFD() {
        return this.mImageFD;
    }

    public MemoryFile getInfoMemoryFile() {
        return this.mInfoMemoryFile;
    }

    public ParcelFileDescriptor getInfoFD() {
        return this.mInfoFD;
    }

    public int getImageSize() {
        return this.mImageSize;
    }

    public int getInfoSize() {
        return this.mInfoSize;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.mImageFD == null) {
            Logger.e((String)TAG, (String)("image fd is null : " + this.toString()));
            this.mImageFD.toString();
        }
        if (this.mInfoFD == null) {
            Logger.e((String)TAG, (String)("info fd is null : " + this.toString()));
            this.mInfoFD.toString();
        }
        dest.writeParcelable((Parcelable)this.mImageFD, flags);
        dest.writeParcelable((Parcelable)this.mInfoFD, flags);
        dest.writeInt(this.mImageSize);
        dest.writeInt(this.mInfoSize);
        dest.writeInt(this.mIndex);
    }

    public String toString() {
        return "image size " + this.getImageSize() + " index " + this.getIndex() + " image fd " + this.getImageFD() + " info fd " + this.getInfoFD();
    }
}

