/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.ipc;

import com.segway.robot.sdk.vision.internal.ipc.MemoryFileBuffer;
import java.io.IOException;

public class MemoryFileBufferQueue {
    private static final int BUFFER_SIZE = 3;
    private MemoryFileBuffer[] mMemoryFileBuffers = new MemoryFileBuffer[3];

    public MemoryFileBufferQueue(int imageSize) throws IOException {
        for (int i = 0; i < this.mMemoryFileBuffers.length; ++i) {
            this.mMemoryFileBuffers[i] = new MemoryFileBuffer(imageSize, i);
        }
    }

    public MemoryFileBuffer next() {
        for (MemoryFileBuffer memoryFileBuffer : this.mMemoryFileBuffers) {
            if (memoryFileBuffer.isDirty()) continue;
            memoryFileBuffer.setDirty(true);
            return memoryFileBuffer;
        }
        return null;
    }

    public void releaseBuffer(int index) {
        this.mMemoryFileBuffers[index].setDirty(false);
    }

    public void close() {
        for (MemoryFileBuffer mMemoryFileBuffer : this.mMemoryFileBuffers) {
            mMemoryFileBuffer.getImageMemoryFile().close();
            mMemoryFileBuffer.getInfoMemoryFile().close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

