package com.segway.robot.sdk.vision.internal.ipc;

import java.io.IOException;

/**
 * Created by ark338 on 2016/11/7.
 * Holds an array of MemoryFileBuffer
 */
public class MemoryFileBufferQueue {
    private static final int BUFFER_SIZE = 3;
    private MemoryFileBuffer[] mMemoryFileBuffers = new MemoryFileBuffer[BUFFER_SIZE];

    public MemoryFileBufferQueue(int imageSize) throws IOException {
        for (int i = 0; i < mMemoryFileBuffers.length; i++) {
            mMemoryFileBuffers[i] = new MemoryFileBuffer(imageSize, i);
        }
    }

    public MemoryFileBuffer next() {
        for (MemoryFileBuffer memoryFileBuffer : mMemoryFileBuffers) {
            if (!memoryFileBuffer.isDirty()) {
                memoryFileBuffer.setDirty(true);
                return memoryFileBuffer;
            }
        }
        return null;
    }

    public void releaseBuffer(int index) {
        mMemoryFileBuffers[index].setDirty(false);
    }

    public void close() {
        for (MemoryFileBuffer mMemoryFileBuffer : mMemoryFileBuffers) {
            mMemoryFileBuffer.getImageMemoryFile().close();
            mMemoryFileBuffer.getInfoMemoryFile().close();
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        close();
    }
}
