package com.segway.robot.sdk.vision.stream;

import android.support.annotation.IntDef;

/**
 * Supported frame rate for the color and depth images.
 */
public interface FrameRate {
    /**
     * 30 fps
     */
    int FPS_30 = 30;

    /**
     * 60 fps, support fish eye only
     */
    int FPS_60 = 60;

    /**
     * 15 fps
     */
    int FPS_15 = 15;

    /**
     * 6 fps
     */
    int FPS_6 = 6;

    @IntDef ({FPS_6, FPS_15, FPS_30, FPS_60})
    @interface VisionFrameRate {}
}
