package com.segway.robot.sdk.vision.imu;

import java.nio.ByteBuffer;

/**
 * Created by ark338 on 16/4/6.
 */
public interface IMUDataCallback {
    /**
     * The inertial measurement unit (IMU) data callback. Called when new IMU data is ready.
     * @param byteBuffer the IMU data
     * @param length the length of the data.
     * @param frameCount the frame count in ByteBuffer.
     */
    void onNewData(ByteBuffer byteBuffer, int length, int frameCount);
}
