package com.segway.robot.sdk.vision.basic;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by ark338 on 2016/10/24.
 */

public class Matrix2F implements Parcelable{
    public float[][] matrix = new float[2][2];

    public Matrix2F(){}

    protected Matrix2F(Parcel in) {
        matrix[0][0] = in.readFloat();
        matrix[0][1] = in.readFloat();
        matrix[1][0] = in.readFloat();
        matrix[1][1] = in.readFloat();
    }

    public static final Creator<Matrix2F> CREATOR = new Creator<Matrix2F>() {
        @Override
        public Matrix2F createFromParcel(Parcel in) {
            return new Matrix2F(in);
        }

        @Override
        public Matrix2F[] newArray(int size) {
            return new Matrix2F[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(matrix[0][0]);
        dest.writeFloat(matrix[0][1]);
        dest.writeFloat(matrix[1][0]);
        dest.writeFloat(matrix[1][1]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2; i ++) {
            sb.append(matrix[i].toString());
        }
        return sb.toString();
    }

    public void copyFrom(float[][] src) {
        if (src.length != 2 || src[0].length != 2 || src[1].length != 2) {
            throw new IllegalArgumentException("the matrix should be 2 x 2");
        }

        for (int i = 0; i < 2; i++) {
            for (int j = 0; j < 2; j++) {
                matrix[i][j] = src[i][j];
            }
        }
    }


}
