package com.segway.robot.sdk.vision.calibration;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Calibration data for fish eye camera and IMU
 */

public class MotionModuleCalibration implements Parcelable{
    public SensorIntrinsics accelIntrinsics = new SensorIntrinsics();
    public SensorIntrinsics gyroIntrinsics = new SensorIntrinsics();
    public Intrinsic2 fishEyeIntrinsics = new Intrinsic2();
    public Extrinsic fishEyeToDepth = new Extrinsic();
    public Extrinsic depthToImu = new Extrinsic();
    public Extrinsic fishEyeToImu = new Extrinsic();
    public Extrinsic colorToImu = new Extrinsic();

    public MotionModuleCalibration() {
    }

    protected MotionModuleCalibration(Parcel in) {
        accelIntrinsics = in.readParcelable(SensorIntrinsics.class.getClassLoader());
        gyroIntrinsics = in.readParcelable(SensorIntrinsics.class.getClassLoader());
        fishEyeIntrinsics = in.readParcelable(Intrinsic2.class.getClassLoader());
        fishEyeToDepth = in.readParcelable(Extrinsic.class.getClassLoader());
        depthToImu = in.readParcelable(Extrinsic.class.getClassLoader());
        fishEyeToImu = in.readParcelable(Extrinsic.class.getClassLoader());
        colorToImu = in.readParcelable(Extrinsic.class.getClassLoader());
    }

    public static final Creator<MotionModuleCalibration> CREATOR = new Creator<MotionModuleCalibration>() {
        @Override
        public MotionModuleCalibration createFromParcel(Parcel in) {
            return new MotionModuleCalibration(in);
        }

        @Override
        public MotionModuleCalibration[] newArray(int size) {
            return new MotionModuleCalibration[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(accelIntrinsics, flags);
        dest.writeParcelable(gyroIntrinsics, flags);
        dest.writeParcelable(fishEyeIntrinsics, flags);
        dest.writeParcelable(fishEyeToDepth, flags);
        dest.writeParcelable(depthToImu, flags);
        dest.writeParcelable(fishEyeToImu, flags);
        dest.writeParcelable(colorToImu, flags);
    }

    @Override
    public String toString() {
        return "MotionModuleCalibration{" +
                "\naccelIntrinsics=" + accelIntrinsics +
                "\ngyroIntrinsics=" + gyroIntrinsics +
                "\nfishEyeIntrinsics=" + fishEyeIntrinsics +
                "\nfishEyeToDepth=" + fishEyeToDepth +
                "\ndepthToImu=" + depthToImu +
                "\nfishEyeToImu=" + fishEyeToImu +
                "\ncolorToImu=" + colorToImu +
                "\n}";
    }
}
