package com.segway.robot.sdk.vision.stream;

import android.support.annotation.IntDef;

/**
 * the supported pixel formats.
 */
public abstract class PixelFormat {

    /**
     * RGBA8888 format, 4 bytes per pixel, for a color image.
     */
    public static final int RGBA8888 = 1;

    /**
     * Z16 format, 2 bytes per pixel, for a depth image.
     */
    public static final int Z16 = 2;

    /**
     * yv12 format, 12 bits per pixel, for a depth image.
     */
    public static final int YV12 = 5;

    /**
     * 1 byte for grey.
     */
    public static final int A8 = 6;

    @IntDef ({RGBA8888, Z16, YV12, A8})
    public @interface VisionPixelFormat{}

    /**
     * Get the pixel length for different pixel formats.
     * @param pixelFormat the pixel format.
     * @return pixel the length in bytes or bits.
     */
    public static float getPixelBytes(@VisionPixelFormat int pixelFormat) {
        switch (pixelFormat) {
            case RGBA8888:
                return 4.0f;
            case Z16:
                return 2.0f;
            case YV12:
                return 1.5f;
            case A8:
                return 1.0f;
            default:
                return 0.0f;
        }
    }
}
