/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision;

import android.content.Context;
import android.util.SparseArray;
import android.view.Surface;
import com.segway.robot.sdk.base.bind.BindController;
import com.segway.robot.sdk.base.bind.ForegroundBindController;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.vision.DTS;
import com.segway.robot.sdk.vision.ImageStreamCallback;
import com.segway.robot.sdk.vision.VisionServiceManager;
import com.segway.robot.sdk.vision.calibration.ColorDepthCalibration;
import com.segway.robot.sdk.vision.frame.Frame;
import com.segway.robot.sdk.vision.frame.FrameImpl;
import com.segway.robot.sdk.vision.frame.FrameInfo;
import com.segway.robot.sdk.vision.stream.StreamInfo;
import java.nio.ByteBuffer;

public class Vision {
    private static Vision mInstance = new Vision();
    private BindController mBindController = new ForegroundBindController();
    private boolean mBindControllerInit;
    private SparseArray<FrameListener> mFrameListenerSparseArray = new SparseArray();
    private final VisionServiceManager mVisionServiceManager = VisionServiceManager.getInstance();
    private final DTS mDTS = new DTS(this.mVisionServiceManager);

    public static Vision getInstance() {
        return mInstance;
    }

    protected Vision() {
    }

    public synchronized boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        if (!this.mBindControllerInit) {
            this.mBindControllerInit = true;
            this.mBindController.init(context, (ServiceBinder)this.mVisionServiceManager);
        }
        if (this.mBindController.bindAcceptable()) {
            return this.mVisionServiceManager.bindService(context, listener);
        }
        return false;
    }

    public synchronized void unbindService() {
        this.mVisionServiceManager.unbindService();
    }

    public StreamInfo[] getActivatedStreamInfo() {
        int count = 0;
        for (StreamInfo info : this.mVisionServiceManager.getActivatedStreamProfiles()) {
            if (info.getStreamType() != 1 && info.getStreamType() != 2) continue;
            ++count;
        }
        StreamInfo[] streamInfos = new StreamInfo[count];
        int i = 0;
        for (StreamInfo info : this.mVisionServiceManager.getActivatedStreamProfiles()) {
            if (info.getStreamType() != 1 && info.getStreamType() != 2) continue;
            streamInfos[i++] = info;
        }
        return streamInfos;
    }

    public StreamInfo getStreamInfo(int streamType) {
        StreamInfo[] infos;
        for (StreamInfo info : infos = this.mVisionServiceManager.getActivatedStreamProfiles()) {
            if (info.getStreamType() != streamType) continue;
            return info;
        }
        return null;
    }

    public synchronized void startPreview(int streamType, Surface surface) {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        if (this.getStreamInfo(streamType) == null) {
            throw new IllegalArgumentException("Stream type:" + streamType + " illegal or not activated");
        }
        this.mVisionServiceManager.preview(streamType, surface, false);
    }

    public synchronized void stopPreview(int streamType) {
        if (this.getStreamInfo(streamType) == null) {
            throw new IllegalArgumentException("Stream type:" + streamType + " illegal or not activated");
        }
        this.mVisionServiceManager.stopPreview(streamType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startListenFrame(final int streamType, final FrameListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        StreamInfo streamInfo = this.getStreamInfo(streamType);
        if (streamInfo == null) {
            throw new IllegalArgumentException("Stream type:" + streamType + " illegal or not activated");
        }
        SparseArray<FrameListener> sparseArray = this.mFrameListenerSparseArray;
        synchronized (sparseArray) {
            if (this.mFrameListenerSparseArray.get(streamType) != null) {
                throw new IllegalArgumentException("Stream type:" + streamType + " is listening");
            }
            this.mFrameListenerSparseArray.append(streamType, (Object)listener);
        }
        this.mVisionServiceManager.startImageTransferMemoryFileBuffer(streamInfo, new ImageStreamCallback(){

            @Override
            public void onNewImage(FrameInfo frameInfo, ByteBuffer buffer) {
                FrameImpl frame = new FrameImpl(frameInfo, buffer);
                listener.onNewFrame(streamType, frame);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopListenFrame(int streamType) {
        StreamInfo streamInfo = this.getStreamInfo(streamType);
        if (streamInfo == null) {
            throw new IllegalArgumentException("Stream type:" + streamType + " illegal or not activated");
        }
        SparseArray<FrameListener> sparseArray = this.mFrameListenerSparseArray;
        synchronized (sparseArray) {
            if (this.mFrameListenerSparseArray.get(streamType) == null) {
                return;
            }
            this.mFrameListenerSparseArray.remove(streamType);
        }
        this.mVisionServiceManager.stopImageTransferMemoryFileBuffer(streamInfo.getStreamType());
    }

    public ColorDepthCalibration getColorDepthCalibrationData() {
        return this.mVisionServiceManager.getColorDepthCalibrationData();
    }

    public DTS getDTS() {
        return this.mDTS;
    }

    public static interface FrameListener {
        public void onNewFrame(int var1, Frame var2);
    }
}

