package com.segway.robot.sdk.vision.frame;

import com.segway.robot.sdk.base.time.StampedData;

import java.nio.ByteBuffer;

/**
 * Created by ark338 on 2016/9/28.
 */

public class FrameImpl implements Frame {
    private final FrameInfo mFrameInfo;
    private final ByteBuffer mBuffer;
    private final long mTimdStamp;
    long mTid;


    public FrameImpl(FrameInfo frameInfo, ByteBuffer buffer) {
        mFrameInfo = frameInfo;
        mBuffer = buffer;
        mTid = System.currentTimeMillis();
        mTimdStamp = frameInfo.getIMUTimeStamp();
    }

    @Override
    public long getTid() {
        return mTid;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return mBuffer;
    }

    @Override
    public FrameInfo getInfo() {
        return mFrameInfo;
    }

    @Override
    public long getTimestamp() {
        return mTimdStamp;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - getTimestamp();
    }
}
