package com.segway.robot.sdk.vision.internal.ipc;

import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.frame.FrameInfo;

import java.io.FileDescriptor;
import java.io.IOException;

/**
 * Created by ark338 on 2016/11/7.
 */
public class MemoryFileBuffer implements Parcelable {
    private static final String TAG = "MemoryFileBuffer";
    static int seed = 0;
    static ClassLoader mParcelFileDescriptorClassLoader = ParcelFileDescriptor.class.getClassLoader();
    private MemoryFile mImageMemoryFile;
    private int mImageSize;
    private int mIndex;
    private int mInfoSize;
    private MemoryFile mInfoMemoryFile;
    private ParcelFileDescriptor mImageFD;
    private ParcelFileDescriptor mInfoFD;
    private boolean isDirty;

    public MemoryFileBuffer(int size, int index) throws IOException {
        mImageSize = size;
        mIndex = index;
        mInfoSize = FrameInfo.SIZE;
        mImageMemoryFile = new MemoryFile("segway.vision.image." + seed, size);
        mInfoMemoryFile = new MemoryFile("segway.vision.info." + seed++, mInfoSize);
        mImageMemoryFile.allowPurging(false);
        mInfoMemoryFile.allowPurging(false);
        mImageFD = MemoryFileUtil.createParcelFileDescriptor(MemoryFileUtil.getFileDescriptor(mImageMemoryFile));
        mInfoFD = MemoryFileUtil.createParcelFileDescriptor(MemoryFileUtil.getFileDescriptor(mInfoMemoryFile));
    }

    protected MemoryFileBuffer(Parcel in) {
        mImageFD = in.readParcelable(mParcelFileDescriptorClassLoader);
        mInfoFD = in.readParcelable(mParcelFileDescriptorClassLoader);
        mImageSize = in.readInt();
        mInfoSize = in.readInt();
        mIndex = in.readInt();

    }

    public MemoryFile getImageMemoryFile() {
        return mImageMemoryFile;
    }

    public ParcelFileDescriptor getImageFD() {
        return mImageFD;
    }

    public MemoryFile getInfoMemoryFile() {
        return mInfoMemoryFile;
    }

    public ParcelFileDescriptor getInfoFD() {
        return mInfoFD;
    }

    public int getImageSize() {
        return mImageSize;
    }

    public int getInfoSize() {
        return mInfoSize;
    }

    public int getIndex() {
        return mIndex;
    }

    public boolean isDirty() {
        return isDirty;
    }

    public void setDirty(boolean dirty) {
        isDirty = dirty;
    }

    public static final Creator<MemoryFileBuffer> CREATOR = new Creator<MemoryFileBuffer>() {
        @Override
        public MemoryFileBuffer createFromParcel(Parcel in) {
            return new MemoryFileBuffer(in);
        }

        @Override
        public MemoryFileBuffer[] newArray(int size) {
            return new MemoryFileBuffer[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (mImageFD == null) {
            Logger.e(TAG, "image fd is null : " + this.toString());
            mImageFD.toString();
        }

        if (mInfoFD == null) {
            Logger.e(TAG, "info fd is null : " + this.toString());
            mInfoFD.toString();
        }

        dest.writeParcelable(mImageFD, flags);
        dest.writeParcelable(mInfoFD, flags);
        dest.writeInt(mImageSize);
        dest.writeInt(mInfoSize);
        dest.writeInt(mIndex);
    }

    @Override
    public String toString() {
        return "image size " + getImageSize() + " index " + getIndex()
                + " image fd " + getImageFD() + " info fd " + getInfoFD();
    }
}
