package com.segway.robot.sdk.vision.internal;

import android.support.annotation.IntDef;

/**
 * define image transfer type
 * Notice: definition MUST NOT above 3, because AprSenseService keep ONLY 2 bit for transfer type
 */
public interface ImageTransferType {
    /**
     * server push image to client
     */
    int PUSH = 1;

    /**
     * client read image from server
     */
    int PULL = 2;

    @IntDef({PUSH,PULL})
    @interface VisionImageTransferType{}
}
