/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.frame;

import com.segway.robot.sdk.base.time.StampedData;
import com.segway.robot.sdk.vision.frame.Frame;
import com.segway.robot.sdk.vision.frame.FrameInfo;
import java.nio.ByteBuffer;

public class FrameImpl
implements Frame {
    private final FrameInfo mFrameInfo;
    private final ByteBuffer mBuffer;
    private final long mTimdStamp;
    long mTid;

    public FrameImpl(FrameInfo frameInfo, ByteBuffer buffer) {
        this.mFrameInfo = frameInfo;
        this.mBuffer = buffer;
        this.mTid = System.currentTimeMillis();
        this.mTimdStamp = frameInfo.getIMUTimeStamp();
    }

    @Override
    public long getTid() {
        return this.mTid;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.mBuffer;
    }

    @Override
    public FrameInfo getInfo() {
        return this.mFrameInfo;
    }

    public long getTimestamp() {
        return this.mTimdStamp;
    }

    public long diff(StampedData source) {
        return source.getTimestamp() - this.getTimestamp();
    }
}

