/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Environment;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.segway.robot.algo.dts.BaseControlCommand;
import com.segway.robot.algo.dts.DTSPerson;
import com.segway.robot.algo.dts.IPersonDetectionListener;
import com.segway.robot.algo.dts.IPersonTrackingListener;
import com.segway.robot.algo.dts.IPlannerPersonTackingListener;
import com.segway.robot.algo.dts.PersonDetectListener;
import com.segway.robot.algo.dts.PersonTrackingListener;
import com.segway.robot.algo.dts.PersonTrackingProfile;
import com.segway.robot.algo.dts.PersonTrackingWithPlannerListener;
import com.segway.robot.algo.generaldts.DTSObject;
import com.segway.robot.algo.generaldts.GeneralTrackingListener;
import com.segway.robot.algo.generaldts.GeneralTrackingProfile;
import com.segway.robot.algo.generaldts.IGeneralTrackingListener;
import com.segway.robot.sdk.base.bind.ServiceBinder;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.base.version.VersionMismatchException;
import com.segway.robot.sdk.vision.AprSenseStateCallback;
import com.segway.robot.sdk.vision.IAprSenseService;
import com.segway.robot.sdk.vision.IAprSenseServiceCallback;
import com.segway.robot.sdk.vision.ImageStreamCallback;
import com.segway.robot.sdk.vision.VisionServiceCallback;
import com.segway.robot.sdk.vision.VisionServiceException;
import com.segway.robot.sdk.vision.calibration.ColorDepthCalibration;
import com.segway.robot.sdk.vision.calibration.MotionModuleCalibration;
import com.segway.robot.sdk.vision.frame.DepthFrameInfo;
import com.segway.robot.sdk.vision.frame.FishEyeFrameInfo;
import com.segway.robot.sdk.vision.frame.Frame;
import com.segway.robot.sdk.vision.frame.FrameInfo;
import com.segway.robot.sdk.vision.imu.IIMUDataCallback;
import com.segway.robot.sdk.vision.imu.IMUCallbackBundle;
import com.segway.robot.sdk.vision.imu.IMUDataCallback;
import com.segway.robot.sdk.vision.internal.framebuffer.CountableFrame;
import com.segway.robot.sdk.vision.internal.framebuffer.FrameBuffer;
import com.segway.robot.sdk.vision.internal.framebuffer.RecyclableFrame2;
import com.segway.robot.sdk.vision.internal.ipc.MemoryFileBuffer;
import com.segway.robot.sdk.vision.internal.ipc.MemoryFileBufferCallback;
import com.segway.robot.sdk.vision.internal.socket.FrameClientThread;
import com.segway.robot.sdk.vision.internal.socket.ImageReaderThreadManager;
import com.segway.robot.sdk.vision.person.FindPersonsHandler;
import com.segway.robot.sdk.vision.person.Person;
import com.segway.robot.sdk.vision.person.PersonDetectCallback;
import com.segway.robot.sdk.vision.stream.FrameRate;
import com.segway.robot.sdk.vision.stream.PixelFormat;
import com.segway.robot.sdk.vision.stream.Resolution;
import com.segway.robot.sdk.vision.stream.StreamInfo;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class VisionServiceManager
implements ServiceBinder {
    private static final String TAG = "VisionServiceManager";
    private static final String SERVICE_PACKAGE_NAME = "com.segway.robot.host.coreservice.vision";
    private static final String SERVICE_CLASS_NAME = "com.segway.robot.host.coreservice.vision.AprSenseService";
    private static final String LOGGER_CONFIG_FILE_PATH = Environment.getExternalStorageDirectory().getPath() + "/logger/VisionSDK.config";
    private static final int SURFACE_HOLDER_CALLBACK_TAG_KEY = 701157500;
    private static final int SURFACE_HOLDER_PROFILE_TAG_KEY = 701157501;
    private static final int IMU_DATA_SIZE = 800;
    private static VisionServiceManager mInstance;
    private Context mContext;
    private ServiceBinder.BindStateListener mListener;
    private Object mDummy = new Object();
    private IAprSenseService mAprSenseAIDLService;
    private AtomicBoolean mDTSEnabled = new AtomicBoolean(false);
    private PersonDetectListener mPersonDetectListener = null;
    private PersonTrackingListener mPersonTrackingListener = null;
    private PersonTrackingWithPlannerListener mPlannerPersonTrackingListener = null;
    private GeneralTrackingListener mGeneralTrackingListener = null;
    private final List<VisionServiceCallback> mVisionServiceCallbacks = new ArrayList<VisionServiceCallback>();
    private final List<AprSenseStateCallback> mAprSenseStateCallback = new ArrayList<AprSenseStateCallback>();
    private final List<PersonDetectCallback> mPersonDetectCallback = new ArrayList<PersonDetectCallback>();
    private final List<IMUCallbackBundle> mIMUDataCallbacks = new ArrayList<IMUCallbackBundle>();
    private final SparseArray<Object> mImageCallbackMap = new SparseArray();
    private final SparseArray<Object> mPreviewMap = new SparseArray();
    private final SparseArray<FrameBuffer> mFrameBufferMap = new SparseArray();
    private final SparseArray<FrameClientThread> mFrameTransferMap = new SparseArray();
    private final SparseArray<SharedMemoryHolder> mFrameTransferSharedMemoryMap = new SparseArray();
    private final SparseArray<ByteBuffer> mMemoryFileBufferCacheArray = new SparseArray();
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            VisionServiceManager.this.mAprSenseAIDLService = IAprSenseService.Stub.asInterface(service);
            VisionServiceManager.this.afterOnServiceConnected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            int i;
            VisionServiceManager.this.mAprSenseAIDLService = null;
            VisionServiceManager.this.notifyServiceDisconnected();
            VisionServiceManager.this.mListener.onUnbind("Service disconnected.");
            VisionServiceManager.this.mContext = null;
            Object object = VisionServiceManager.this.mFrameTransferMap;
            synchronized (object) {
                for (i = 0; i < VisionServiceManager.this.mFrameTransferMap.size(); ++i) {
                    FrameClientThread frameClientThread = (FrameClientThread)VisionServiceManager.this.mFrameTransferMap.valueAt(i);
                    frameClientThread.disconnect();
                }
                VisionServiceManager.this.mFrameTransferMap.clear();
            }
            object = VisionServiceManager.this.mFrameTransferSharedMemoryMap;
            synchronized (object) {
                for (i = 0; i < VisionServiceManager.this.mFrameTransferSharedMemoryMap.size(); ++i) {
                    SharedMemoryHolder sharedMemoryHolder = (SharedMemoryHolder)VisionServiceManager.this.mFrameTransferSharedMemoryMap.valueAt(i);
                    sharedMemoryHolder.parcelFileDescriptor = null;
                    try {
                        sharedMemoryHolder.inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    sharedMemoryHolder.inputStream = null;
                }
                VisionServiceManager.this.mFrameTransferSharedMemoryMap.clear();
            }
            object = VisionServiceManager.this.mImageCallbackMap;
            synchronized (object) {
                VisionServiceManager.this.mImageCallbackMap.clear();
            }
            object = VisionServiceManager.this.mFrameBufferMap;
            synchronized (object) {
                for (i = 0; i < VisionServiceManager.this.mFrameBufferMap.size(); ++i) {
                    FrameBuffer frameBuffer = (FrameBuffer)VisionServiceManager.this.mFrameBufferMap.valueAt(i);
                    frameBuffer.release();
                }
                VisionServiceManager.this.mFrameBufferMap.clear();
            }
            object = VisionServiceManager.this.mPreviewMap;
            synchronized (object) {
                VisionServiceManager.this.mPreviewMap.clear();
            }
            object = VisionServiceManager.this.mIMUDataCallbacks;
            synchronized (object) {
                VisionServiceManager.this.mIMUDataCallbacks.clear();
            }
            object = VisionServiceManager.this.mMemoryFileBufferCacheArray;
            synchronized (object) {
                VisionServiceManager.this.mMemoryFileBufferCacheArray.clear();
            }
            Logger.d((String)VisionServiceManager.TAG, (String)"VisionService disconnected.");
        }
    };
    private IPersonDetectionListener.Stub mIPersonDetectionListener = new IPersonDetectionListener.Stub(){

        @Override
        public void onPersonDetected(DTSPerson[] person) throws RemoteException {
            if (VisionServiceManager.this.mPersonDetectListener != null) {
                VisionServiceManager.this.mPersonDetectListener.onPersonDetected(person);
            }
        }

        @Override
        public void onPersonDetectionResult(DTSPerson[] person) throws RemoteException {
            if (VisionServiceManager.this.mPersonDetectListener != null) {
                VisionServiceManager.this.mPersonDetectListener.onPersonDetectionResult(person);
            }
        }

        @Override
        public void onPersonDetectionError(int errorCode, String message) throws RemoteException {
            if (VisionServiceManager.this.mPersonDetectListener != null) {
                VisionServiceManager.this.mPersonDetectListener.onPersonDetectionError(errorCode, message);
            }
        }
    };
    private IPersonTrackingListener mIPersonTrackingListener = new IPersonTrackingListener.Stub(){

        @Override
        public void onPersonTracking(DTSPerson person) throws RemoteException {
            if (VisionServiceManager.this.mPersonTrackingListener != null) {
                VisionServiceManager.this.mPersonTrackingListener.onPersonTracking(person);
            }
        }

        @Override
        public void onPersonTrackingResult(DTSPerson person) throws RemoteException {
            if (VisionServiceManager.this.mPersonTrackingListener != null) {
                VisionServiceManager.this.mPersonTrackingListener.onPersonTrackingResult(person);
            }
        }

        @Override
        public void onPersonTrackingError(int error, String reason) throws RemoteException {
            if (VisionServiceManager.this.mPersonTrackingListener != null) {
                VisionServiceManager.this.mPersonTrackingListener.onPersonTrackingError(error, reason);
            }
        }
    };
    private IPlannerPersonTackingListener mIPlannerPersonTackingListener = new IPlannerPersonTackingListener.Stub(){

        @Override
        public void onPlannerPersonTrackingResult(DTSPerson person, BaseControlCommand command) throws RemoteException {
            if (VisionServiceManager.this.mPlannerPersonTrackingListener != null) {
                VisionServiceManager.this.mPlannerPersonTrackingListener.onPersonTrackingWithPlannerResult(person, command);
            }
        }

        @Override
        public void onPlannerPersonTrackingError(int error, String reason) throws RemoteException {
            if (VisionServiceManager.this.mPlannerPersonTrackingListener != null) {
                VisionServiceManager.this.mPlannerPersonTrackingListener.onPersonTrackingWithPlannerError(error, reason);
            }
        }
    };
    private IGeneralTrackingListener mIGeneralTrackingListener = new IGeneralTrackingListener.Stub(){

        @Override
        public void onObjectTrackingResult(DTSObject dtsObject) throws RemoteException {
            if (VisionServiceManager.this.mGeneralTrackingListener != null) {
                VisionServiceManager.this.mGeneralTrackingListener.onObjectTrackingResult(dtsObject);
            }
        }

        @Override
        public void onObjectTrackingError(int error, String msg) throws RemoteException {
            if (VisionServiceManager.this.mGeneralTrackingListener != null) {
                VisionServiceManager.this.mGeneralTrackingListener.onObjectTrackingError(error, msg);
            }
        }
    };
    IAprSenseServiceCallback.Stub mAprSenseServiceCallback = new IAprSenseServiceCallback.Stub(){

        @Override
        public void onAprStateChanged(int state, int errorCode, String errorMessage) throws RemoteException {
            switch (state) {
                case 1: {
                    VisionServiceManager.this.notifyAprSenseStarted();
                    break;
                }
                case 2: {
                    VisionServiceManager.this.notifyRealSenseStopped();
                    break;
                }
                case 3: {
                    VisionServiceManager.this.notifyRealSenseError(errorCode, errorMessage);
                }
            }
        }
    };
    FindPersonsHandler.Stub mFindPersonHandler = new FindPersonsHandler.Stub(){

        @Override
        public void onFindPersons(List<Person> persons) throws RemoteException {
            for (PersonDetectCallback personDetectCallback : VisionServiceManager.this.mPersonDetectCallback) {
                personDetectCallback.onPersonDetected(persons);
            }
        }
    };
    IIMUDataCallback.Stub mIImuDataCallback = new IIMUDataCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewData(byte[] buff, int length, int frameCount) throws RemoteException {
            List list = VisionServiceManager.this.mIMUDataCallbacks;
            synchronized (list) {
                for (IMUCallbackBundle bundle : VisionServiceManager.this.mIMUDataCallbacks) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buff);
                    ReadableByteChannel readableByteChannel = Channels.newChannel(byteArrayInputStream);
                    bundle.buffer.rewind();
                    try {
                        readableByteChannel.read(bundle.buffer);
                    }
                    catch (IOException e) {
                        Logger.e((String)VisionServiceManager.TAG, (String)"An error occurs in copying the IMU data.", (Throwable)e);
                    }
                    bundle.buffer.rewind();
                    bundle.callback.onNewData(bundle.buffer, length, frameCount);
                }
            }
        }
    };

    protected void afterOnServiceConnected() {
        try {
            this.mAprSenseAIDLService.addCallback(this.mAprSenseServiceCallback);
            this.mAprSenseAIDLService.addFindPersonHandler(this.mFindPersonHandler);
        }
        catch (RemoteException e) {
            String error = "Cannot add the internal VisionService callback, err = " + e.getMessage();
            this.notifyRealSenseError(1, error);
            this.mListener.onUnbind(error);
            this.unbindService();
            this.mContext = null;
            Logger.e((String)TAG, (String)error, (Throwable)e);
            return;
        }
        try {
            Version serviceVersion = this.mAprSenseAIDLService.getVersion();
            this.getVersion().check("VersionInfo", serviceVersion);
        }
        catch (VersionMismatchException e) {
            String error = "Version mismatch: " + e.getMessage();
            this.mListener.onUnbind(error);
            this.unbindService();
            this.mContext = null;
            Logger.e((String)TAG, (String)error, (Throwable)e);
            return;
        }
        catch (Exception e) {
            String error = "Cannot get VisionService version, err = " + e.getMessage();
            this.mListener.onUnbind(error);
            this.unbindService();
            this.mContext = null;
            Logger.e((String)TAG, (String)error, (Throwable)e);
            return;
        }
        try {
            this.mAprSenseAIDLService.registerClient((IBinder)new Binder(), this.mContext.getPackageName());
        }
        catch (Exception e) {
            String error = "Register client to service error";
            Logger.e((String)TAG, (String)error);
            this.mListener.onUnbind(error);
            this.unbindService();
            this.mContext = null;
            return;
        }
        this.mListener.onBind();
        this.notifyServiceConnected();
        Logger.d((String)TAG, (String)"AprSenseService connected.");
    }

    private VisionServiceManager() {
    }

    static synchronized VisionServiceManager getInstance() {
        if (mInstance == null) {
            mInstance = new VisionServiceManager();
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addVisionServiceCallback(VisionServiceCallback visionServiceCallback) {
        if (visionServiceCallback == null) {
            return;
        }
        List<VisionServiceCallback> list = this.mVisionServiceCallbacks;
        synchronized (list) {
            if (!this.mVisionServiceCallbacks.contains(visionServiceCallback)) {
                this.mVisionServiceCallbacks.add(visionServiceCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeVisionServiceCallback(VisionServiceCallback visionServiceCallback) {
        if (visionServiceCallback == null) {
            return;
        }
        List<VisionServiceCallback> list = this.mVisionServiceCallbacks;
        synchronized (list) {
            this.mVisionServiceCallbacks.remove(visionServiceCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRealSenseStateCallback(AprSenseStateCallback aprSenseStateCallback) {
        if (aprSenseStateCallback == null) {
            return;
        }
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            if (!this.mAprSenseStateCallback.contains(aprSenseStateCallback)) {
                this.mAprSenseStateCallback.add(aprSenseStateCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRealSenseStateCallback(AprSenseStateCallback aprSenseStateCallback) {
        if (aprSenseStateCallback == null) {
            return;
        }
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            this.mAprSenseStateCallback.remove(aprSenseStateCallback);
        }
    }

    public synchronized boolean bindService(Context context, ServiceBinder.BindStateListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null!");
        }
        if (this.mContext != null) {
            return true;
        }
        context = context.getApplicationContext();
        Intent startServiceIntent = new Intent();
        startServiceIntent.setClassName(SERVICE_PACKAGE_NAME, SERVICE_CLASS_NAME);
        startServiceIntent.putExtra("PackageNameFPC", context.getPackageName());
        boolean result = context.bindService(startServiceIntent, this.mServiceConnection, 1);
        if (result) {
            this.mContext = context.getApplicationContext();
            this.mListener = listener;
            Logger.updateConfig((Context)this.mContext, (String)LOGGER_CONFIG_FILE_PATH);
            Logger.i((String)TAG, (String)this.getVersion().toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unbindService() {
        int i;
        if (this.mContext == null) {
            return;
        }
        Object object = this.mFrameTransferMap;
        synchronized (object) {
            for (i = 0; i < this.mFrameTransferMap.size(); ++i) {
                FrameClientThread frameClientThread = (FrameClientThread)this.mFrameTransferMap.valueAt(i);
                frameClientThread.disconnect();
            }
            this.mFrameTransferMap.clear();
        }
        object = this.mFrameTransferSharedMemoryMap;
        synchronized (object) {
            for (i = 0; i < this.mFrameTransferSharedMemoryMap.size(); ++i) {
                SharedMemoryHolder sharedMemoryHolder = (SharedMemoryHolder)this.mFrameTransferSharedMemoryMap.valueAt(i);
                sharedMemoryHolder.parcelFileDescriptor = null;
                try {
                    sharedMemoryHolder.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                sharedMemoryHolder.inputStream = null;
            }
            this.mFrameTransferSharedMemoryMap.clear();
        }
        object = this.mImageCallbackMap;
        synchronized (object) {
            for (i = 0; i < this.mImageCallbackMap.size(); ++i) {
                int streamType = this.mImageCallbackMap.keyAt(i);
                try {
                    this.mAprSenseAIDLService.stopImageTransferMemoryFileBuffer(streamType);
                    continue;
                }
                catch (RemoteException e) {
                    Logger.w((String)TAG, (String)"try to stop image streaming while unbind but caught exception:", (Throwable)e);
                }
            }
            this.mImageCallbackMap.clear();
        }
        object = this.mPreviewMap;
        synchronized (object) {
            for (i = 0; i < this.mPreviewMap.size(); ++i) {
                int streamType = this.mPreviewMap.keyAt(i);
                try {
                    this.mAprSenseAIDLService.stopPreview(streamType);
                    continue;
                }
                catch (RemoteException e) {
                    Logger.w((String)TAG, (String)"try to stop image preview while unbind but caught exception:", (Throwable)e);
                }
            }
            this.mPreviewMap.clear();
        }
        object = this.mMemoryFileBufferCacheArray;
        synchronized (object) {
            this.mMemoryFileBufferCacheArray.clear();
        }
        object = this.mIMUDataCallbacks;
        synchronized (object) {
            this.mIMUDataCallbacks.clear();
        }
        if (this.mContext != null) {
            try {
                this.mAprSenseAIDLService.unregisterClient(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Logger.e((String)TAG, (String)"unregister client error", (Throwable)e);
            }
            this.mContext.unbindService(this.mServiceConnection);
            this.mContext = null;
        }
    }

    public boolean isBind() {
        return this.mContext != null;
    }

    public ServiceBinder.BindStateListener getBindStateListener() {
        return this.mListener;
    }

    synchronized boolean isServiceConnected() {
        return this.mContext != null;
    }

    synchronized void startAprSense(AprSenseStateCallback aprSenseStateCallback) {
        this.checkConnected();
        try {
            if (this.mAprSenseAIDLService.isAprSenseRunning()) {
                throw new VisionServiceException("AprSense is already started.");
            }
            this.mAprSenseAIDLService.startAprSense();
            this.addRealSenseStateCallback(aprSenseStateCallback);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    synchronized void stopAprSense() {
        this.checkConnected();
        try {
            if (!this.mAprSenseAIDLService.isAprSenseRunning()) {
                throw new VisionServiceException("AprSense is not running");
            }
            this.mAprSenseAIDLService.stopAprSense();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    boolean isAprSenseRunning() {
        this.checkConnected();
        try {
            return this.mAprSenseAIDLService.isAprSenseRunning();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    void enableStream(int streamType, @Resolution.VisionResolution int resolution, @FrameRate.VisionFrameRate int fps, @PixelFormat.VisionPixelFormat int pixelFormat) throws VisionServiceException {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.enableStream(streamType, resolution, fps, pixelFormat);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    void enableStream(StreamInfo streamInfo) {
        this.checkConnected();
        int resolution = Resolution.toVisionServiceResolution(streamInfo.getWidth(), streamInfo.getHeight());
        if (resolution == 0) {
            throw new VisionServiceException("The width or height is not supported.");
        }
        try {
            this.mAprSenseAIDLService.enableStream(streamInfo.getStreamType(), resolution, streamInfo.getFps(), streamInfo.getPixelFormat());
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    void cleanStreams() throws VisionServiceException {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.cleanStreams();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    StreamInfo[] getActivatedStreamProfiles() throws VisionServiceException {
        this.checkConnected();
        try {
            return this.mAprSenseAIDLService.getActivatedStreamProfile();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    void startPreview(final SurfaceView surfaceView, final StreamInfo streamInfo, final boolean showPerson) throws VisionServiceException {
        this.checkConnected();
        this.checkAprSenseStarted();
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        surfaceHolder.setFixedSize(streamInfo.getWidth(), streamInfo.getHeight());
        SurfaceHolder.Callback callback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                Logger.i((String)VisionServiceManager.TAG, (String)("surfaceCreated id = " + surfaceView.getId()));
                try {
                    VisionServiceManager.this.preview(streamInfo.getStreamType(), holder.getSurface(), showPerson);
                }
                catch (VisionServiceException e) {
                    VisionServiceManager.this.notifyRealSenseError(4, e.getMessage());
                }
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                Logger.i((String)VisionServiceManager.TAG, (String)("surfaceChanged id = " + surfaceView.getId() + " format = " + format + " width = " + width + " height = " + width));
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                Logger.i((String)VisionServiceManager.TAG, (String)("surfaceDestroyed id = " + surfaceView.getId()));
            }
        };
        surfaceView.setTag(701157500, (Object)callback);
        surfaceView.setTag(701157501, (Object)streamInfo);
        surfaceHolder.addCallback(callback);
    }

    void stopPreview(SurfaceView surfaceView) {
        this.checkConnected();
        this.checkAprSenseStarted();
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        SurfaceHolder.Callback callback = (SurfaceHolder.Callback)surfaceView.getTag(701157500);
        StreamInfo streamInfo = (StreamInfo)surfaceView.getTag(701157501);
        if (callback != null) {
            surfaceHolder.removeCallback(callback);
        }
        try {
            this.mAprSenseAIDLService.stopPreview(streamInfo.getStreamType());
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startImageStream(StreamInfo streamInfo, ImageStreamCallback callback) {
        this.checkConnected();
        if (streamInfo == null) {
            throw new IllegalArgumentException("The stream profile cannot be null.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("The image stream callback cannot be null.");
        }
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamInfo.getStreamType()) != null) {
                throw new VisionServiceException("The stream is duplicated.");
            }
            this.mImageCallbackMap.put(streamInfo.getStreamType(), this.mDummy);
        }
        try {
            String address = this.mAprSenseAIDLService.setupImageTransferSocket(streamInfo.getStreamType(), 1);
            ImageReaderThreadManager.getInstance().addConnection(streamInfo, address, callback);
        }
        catch (Exception e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startImageStreamToBuffer(StreamInfo streamInfo) {
        FrameBuffer frameBuffer;
        this.checkConnected();
        if (streamInfo == null) {
            throw new IllegalArgumentException("stream profile can't be null");
        }
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamInfo.getStreamType()) != null) {
                throw new VisionServiceException("stream duplicated");
            }
            this.mImageCallbackMap.put(streamInfo.getStreamType(), this.mDummy);
        }
        SparseArray<FrameBuffer> sparseArray2 = this.mFrameBufferMap;
        synchronized (sparseArray2) {
            if (this.mFrameBufferMap.get(streamInfo.getStreamType()) == null) {
                this.mFrameBufferMap.put(streamInfo.getStreamType(), (Object)new FrameBuffer());
            }
            frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamInfo.getStreamType());
        }
        try {
            String address = this.mAprSenseAIDLService.setupImageTransferSocket(streamInfo.getStreamType(), 1);
            ImageReaderThreadManager.getInstance().addConnection(streamInfo, address, frameBuffer);
        }
        catch (Exception e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startImageTransferMemoryFileBuffer(final StreamInfo streamInfo, final ImageStreamCallback callback) {
        this.checkConnected();
        if (streamInfo == null) {
            throw new IllegalArgumentException("The stream profile cannot be null.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("The image stream callback cannot be null.");
        }
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamInfo.getStreamType()) != null) {
                throw new VisionServiceException("The stream is duplicated.");
            }
            this.mImageCallbackMap.put(streamInfo.getStreamType(), this.mDummy);
        }
        try {
            this.mAprSenseAIDLService.startImageTransferMemoryFileBuffer(streamInfo.getStreamType(), new MemoryFileBufferCallback.Stub(){
                long prevTimeStamp;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onNewImage(MemoryFileBuffer memoryFileBuffer) throws RemoteException {
                    try {
                        ByteBuffer imageBuffer = VisionServiceManager.this.getMappedBufferFromMemoryFile(streamInfo.getStreamType(), memoryFileBuffer.getIndex(), 0, memoryFileBuffer.getImageFD().getFileDescriptor(), memoryFileBuffer.getImageSize());
                        ByteBuffer infoBuffer = VisionServiceManager.this.getMappedBufferFromMemoryFile(streamInfo.getStreamType(), memoryFileBuffer.getIndex(), 1, memoryFileBuffer.getInfoFD().getFileDescriptor(), memoryFileBuffer.getInfoSize());
                        if (imageBuffer == null || infoBuffer == null) {
                            Logger.e((String)VisionServiceManager.TAG, (String)"get mapped buffer error");
                            VisionServiceManager.this.releaseMemoryFileBuffer(streamInfo.getStreamType(), memoryFileBuffer.getIndex());
                            return;
                        }
                        FrameInfo frameInfo = FrameInfo.fromByteBuffer(infoBuffer);
                        long ts = frameInfo.getIMUTimeStamp();
                        if (ts > 0L && ts <= this.prevTimeStamp) {
                            Logger.w((String)"TAG", (String)"get frame ts low than previous, clean share mem cache and drop frame");
                            SparseArray sparseArray = VisionServiceManager.this.mMemoryFileBufferCacheArray;
                            synchronized (sparseArray) {
                                VisionServiceManager.this.mMemoryFileBufferCacheArray.clear();
                            }
                            VisionServiceManager.this.releaseMemoryFileBuffer(streamInfo.getStreamType(), memoryFileBuffer.getIndex());
                            return;
                        }
                        this.prevTimeStamp = ts;
                        callback.onNewImage(frameInfo, imageBuffer);
                        VisionServiceManager.this.releaseMemoryFileBuffer(streamInfo.getStreamType(), memoryFileBuffer.getIndex());
                        return;
                    }
                    finally {
                        try {
                            memoryFileBuffer.getImageFD().close();
                        }
                        catch (IOException iOException) {}
                        try {
                            memoryFileBuffer.getInfoFD().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
        }
        catch (RemoteException e) {
            Logger.e((String)TAG, (String)"startImageTransferMemoryFileBuffer error", (Throwable)e);
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startImageStreamToBufferByMemoryFile(final StreamInfo streamInfo) {
        FrameBuffer frameBuffer;
        this.checkConnected();
        if (streamInfo == null) {
            throw new IllegalArgumentException("stream profile can't be null");
        }
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamInfo.getStreamType()) != null) {
                throw new VisionServiceException("stream duplicated");
            }
            this.mImageCallbackMap.put(streamInfo.getStreamType(), this.mDummy);
        }
        SparseArray<FrameBuffer> sparseArray2 = this.mFrameBufferMap;
        synchronized (sparseArray2) {
            if (this.mFrameBufferMap.get(streamInfo.getStreamType()) == null) {
                this.mFrameBufferMap.put(streamInfo.getStreamType(), (Object)new FrameBuffer());
            }
            frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamInfo.getStreamType());
        }
        final FrameBuffer finalFrameBuffer = frameBuffer;
        final RecyclableFrame2.FrameReleaseHandler frameReleaseHandler = new RecyclableFrame2.FrameReleaseHandler(){

            @Override
            public void releaseFrame(int streamType, int index) {
                IAprSenseService stub = VisionServiceManager.this.mAprSenseAIDLService;
                if (stub == null) {
                    Log.w((String)VisionServiceManager.TAG, (String)"mAprSenseAIDLService is null while releaseFrame service may be disconnected");
                    return;
                }
                try {
                    stub.releaseMemoryFileBuffer(streamType, index);
                }
                catch (RemoteException e) {
                    Logger.e((String)VisionServiceManager.TAG, (String)"Release memory file error", (Throwable)e);
                }
            }
        };
        try {
            SparseArray<ByteBuffer> sparseArray3 = this.mMemoryFileBufferCacheArray;
            synchronized (sparseArray3) {
                this.mMemoryFileBufferCacheArray.clear();
            }
            this.mAprSenseAIDLService.startImageTransferMemoryFileBuffer(streamInfo.getStreamType(), new MemoryFileBufferCallback.Stub(){
                long prevTimeStamp;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onNewImage(MemoryFileBuffer memoryFileBuffer) throws RemoteException {
                    try {
                        ByteBuffer imageBuffer = VisionServiceManager.this.getMappedBufferFromMemoryFile(streamInfo.getStreamType(), memoryFileBuffer.getIndex(), 0, memoryFileBuffer.getImageFD().getFileDescriptor(), memoryFileBuffer.getImageSize());
                        ByteBuffer infoBuffer = VisionServiceManager.this.getMappedBufferFromMemoryFile(streamInfo.getStreamType(), memoryFileBuffer.getIndex(), 1, memoryFileBuffer.getInfoFD().getFileDescriptor(), memoryFileBuffer.getInfoSize());
                        if (imageBuffer == null || infoBuffer == null) {
                            Logger.e((String)VisionServiceManager.TAG, (String)"get mapped buffer error");
                            VisionServiceManager.this.releaseMemoryFileBuffer(streamInfo.getStreamType(), memoryFileBuffer.getIndex());
                            return;
                        }
                        FrameInfo frameInfo = FrameInfo.fromByteBuffer(infoBuffer);
                        if (frameInfo.getStreamType() != streamInfo.getStreamType()) {
                            Logger.w((String)VisionServiceManager.TAG, (String)"Illegal frame detected, clean share mem cache and drop frame");
                            SparseArray sparseArray = VisionServiceManager.this.mMemoryFileBufferCacheArray;
                            synchronized (sparseArray) {
                                VisionServiceManager.this.mMemoryFileBufferCacheArray.clear();
                            }
                            VisionServiceManager.this.releaseMemoryFileBuffer(frameInfo.getStreamType(), memoryFileBuffer.getIndex());
                            return;
                        }
                        long ts = frameInfo.getIMUTimeStamp();
                        if (ts > 0L && ts <= this.prevTimeStamp) {
                            Logger.w((String)"TAG", (String)"get frame ts low than previous, clean share mem cache and drop frame");
                            SparseArray sparseArray = VisionServiceManager.this.mMemoryFileBufferCacheArray;
                            synchronized (sparseArray) {
                                VisionServiceManager.this.mMemoryFileBufferCacheArray.clear();
                            }
                            VisionServiceManager.this.releaseMemoryFileBuffer(frameInfo.getStreamType(), memoryFileBuffer.getIndex());
                            return;
                        }
                        this.prevTimeStamp = ts;
                        RecyclableFrame2 recyclableFrame2 = RecyclableFrame2.create(streamInfo.getStreamType(), memoryFileBuffer.getIndex(), imageBuffer.capacity(), frameInfo, imageBuffer, frameReleaseHandler);
                        finalFrameBuffer.add(recyclableFrame2);
                        return;
                    }
                    finally {
                        try {
                            memoryFileBuffer.getImageFD().close();
                        }
                        catch (IOException iOException) {}
                        try {
                            memoryFileBuffer.getInfoFD().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
        }
        catch (RemoteException e) {
            Logger.e((String)TAG, (String)"startImageTransferMemoryFileBuffer error", (Throwable)e);
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopImageTransferMemoryFileBuffer(int streamType) {
        this.checkConnected();
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamType) == null) {
                Logger.w((String)TAG, (String)("stopImageTransferMemoryFileBuffer: stream " + streamType + " is not start transfer."));
                return;
            }
            this.mImageCallbackMap.remove(streamType);
        }
        try {
            this.mAprSenseAIDLService.stopImageTransferMemoryFileBuffer(streamType);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
        sparseArray = this.mMemoryFileBufferCacheArray;
        synchronized (sparseArray) {
            this.mMemoryFileBufferCacheArray.clear();
        }
        sparseArray = this.mFrameBufferMap;
        synchronized (sparseArray) {
            FrameBuffer frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamType);
            if (frameBuffer != null) {
                frameBuffer.release();
                this.mFrameBufferMap.remove(streamType);
            }
        }
    }

    void releaseMemoryFileBuffer(int streamType, int index) {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.releaseMemoryFileBuffer(streamType, index);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getMappedBufferFromMemoryFile(int type, int index, int info, FileDescriptor fileDescriptor, int size) {
        ByteBuffer mappedByteBuffer;
        int key = type << 8 | index << 1 | info;
        SparseArray<ByteBuffer> sparseArray = this.mMemoryFileBufferCacheArray;
        synchronized (sparseArray) {
            mappedByteBuffer = (ByteBuffer)this.mMemoryFileBufferCacheArray.get(key);
        }
        if (mappedByteBuffer != null) {
            mappedByteBuffer.rewind();
            return mappedByteBuffer;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileDescriptor);
            mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, size);
            SparseArray<ByteBuffer> sparseArray2 = this.mMemoryFileBufferCacheArray;
            synchronized (sparseArray2) {
                this.mMemoryFileBufferCacheArray.put(key, (Object)mappedByteBuffer);
            }
        }
        catch (IOException e) {
            Logger.e((String)TAG, (String)"map buffer from memory file error", (Throwable)e);
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        mappedByteBuffer.rewind();
        return mappedByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"WrongConstant"})
    void stopImageStream(StreamInfo streamInfo) {
        this.checkConnected();
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamInfo.getStreamType()) == null) {
                throw new VisionServiceException("The stream is not started " + streamInfo.getStreamType());
            }
            this.mImageCallbackMap.remove(streamInfo.getStreamType());
        }
        sparseArray = this.mFrameBufferMap;
        synchronized (sparseArray) {
            FrameBuffer frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamInfo.getStreamType());
            if (frameBuffer != null) {
                frameBuffer.release();
                this.mFrameBufferMap.remove(streamInfo.getStreamType());
            }
        }
        try {
            ImageReaderThreadManager.getInstance().removeConnection(streamInfo);
            this.mAprSenseAIDLService.stopImageTransfer(streamInfo.getStreamType(), 1);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    Frame getLatestFrameForStream(StreamInfo streamInfo, long previousTid) {
        if (streamInfo == null) {
            throw new IllegalArgumentException("stream profile can't be null");
        }
        return this.getLatestFrameForStream(streamInfo.getStreamType(), previousTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Frame getLatestFrameForStream(int streamType, long previousTid) {
        FrameBuffer frameBuffer;
        SparseArray<FrameBuffer> sparseArray = this.mFrameBufferMap;
        synchronized (sparseArray) {
            frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamType);
        }
        if (frameBuffer == null) {
            throw new IllegalArgumentException("stream image transfer not initialized");
        }
        return frameBuffer.getLatest(previousTid);
    }

    void returnFrameToStream(StreamInfo streamInfo, Frame frame) {
        if (streamInfo == null) {
            throw new IllegalArgumentException("stream profile can't be null");
        }
        if (frame == null) {
            throw new IllegalArgumentException("can not return null frame");
        }
        this.returnFrameToStream(streamInfo.getStreamType(), frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnFrameToStream(int streamType, Frame frame) {
        FrameBuffer frameBuffer;
        if (frame == null) {
            throw new IllegalArgumentException("can not return null frame");
        }
        if (frame.getInfo().getStreamType() != streamType) {
            throw new IllegalArgumentException("try to return frame type = " + frame.getInfo().getStreamType() + " to buffer type = " + streamType);
        }
        SparseArray<FrameBuffer> sparseArray = this.mFrameBufferMap;
        synchronized (sparseArray) {
            frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamType);
        }
        if (frameBuffer == null) {
            Logger.w((String)TAG, (String)("return image for stream " + streamType + " but not initialized"));
            ((CountableFrame)frame).lockCountDown();
            return;
        }
        frameBuffer.returnFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableFrameTransfer(StreamInfo profile) {
        String address;
        this.checkConnected();
        SparseArray<FrameClientThread> sparseArray = this.mFrameTransferMap;
        synchronized (sparseArray) {
            if (this.mFrameTransferMap.get(profile.getStreamType()) != null) {
                throw new VisionServiceException("The frame profile is duplicated.");
            }
        }
        try {
            address = this.mAprSenseAIDLService.setupImageTransferSocket(profile.getStreamType(), 2);
        }
        catch (RemoteException e) {
            throw new VisionServiceException("An error occurs in seting up the image transfer socket.", e);
        }
        FrameClientThread frameClientThread = new FrameClientThread(profile);
        frameClientThread.connectServer(address);
        SparseArray<FrameClientThread> sparseArray2 = this.mFrameTransferMap;
        synchronized (sparseArray2) {
            this.mFrameTransferMap.put(profile.getStreamType(), (Object)frameClientThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableFrameTransfer(StreamInfo profile) {
        this.checkConnected();
        SparseArray<FrameClientThread> sparseArray = this.mFrameTransferMap;
        synchronized (sparseArray) {
            FrameClientThread frameClientThread = (FrameClientThread)this.mFrameTransferMap.get(profile.getStreamType());
            if (frameClientThread != null) {
                frameClientThread.disconnect();
                this.mFrameTransferMap.remove(profile.getStreamType());
            }
        }
        try {
            this.mAprSenseAIDLService.stopImageTransfer(profile.getStreamType(), 2);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableFrameTransferMemoryFile(StreamInfo profile) {
        this.checkConnected();
        SparseArray<SharedMemoryHolder> sparseArray = this.mFrameTransferSharedMemoryMap;
        synchronized (sparseArray) {
            if (this.mFrameTransferSharedMemoryMap.get(profile.getStreamType()) != null) {
                throw new VisionServiceException("frame profile duplicated");
            }
        }
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.mAprSenseAIDLService.setupImageTransferSharedMemory(profile.getStreamType(), 2);
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            SharedMemoryHolder sharedMemoryHolder = new SharedMemoryHolder();
            sharedMemoryHolder.parcelFileDescriptor = parcelFileDescriptor;
            sharedMemoryHolder.inputStream = fileInputStream;
            SparseArray<SharedMemoryHolder> sparseArray2 = this.mFrameTransferSharedMemoryMap;
            synchronized (sparseArray2) {
                this.mFrameTransferSharedMemoryMap.put(profile.getStreamType(), (Object)sharedMemoryHolder);
            }
        }
        catch (RemoteException e) {
            throw new VisionServiceException("setup image transfer socket error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableFrameTransferMemoryFile(StreamInfo profile) {
        this.checkConnected();
        SparseArray<SharedMemoryHolder> sparseArray = this.mFrameTransferSharedMemoryMap;
        synchronized (sparseArray) {
            SharedMemoryHolder sharedMemoryHolder = (SharedMemoryHolder)this.mFrameTransferSharedMemoryMap.get(profile.getStreamType());
            if (sharedMemoryHolder != null) {
                sharedMemoryHolder.parcelFileDescriptor = null;
                try {
                    sharedMemoryHolder.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                sharedMemoryHolder.inputStream = null;
                this.mFrameTransferSharedMemoryMap.remove(profile.getStreamType());
            }
        }
        try {
            this.mAprSenseAIDLService.stopImageTransfer(profile.getStreamType(), 2);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    FishEyeFrameInfo getFishEyeFrame(StreamInfo streamInfo, ByteBuffer buffer) {
        this.checkConnected();
        this.checkAprSenseStarted();
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        FrameInfo frameInfo = this.getFrame(streamInfo, buffer);
        if (frameInfo != null) {
            return new FishEyeFrameInfo(frameInfo);
        }
        return null;
    }

    DepthFrameInfo getDepthFrame(StreamInfo streamInfo, ByteBuffer buffer) {
        this.checkConnected();
        this.checkAprSenseStarted();
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        FrameInfo frameInfo = this.getFrame(streamInfo, buffer);
        if (frameInfo != null) {
            return new DepthFrameInfo(frameInfo);
        }
        return null;
    }

    @Deprecated
    FrameInfo getColorFrame(StreamInfo streamInfo, ByteBuffer buffer) {
        this.checkConnected();
        this.checkAprSenseStarted();
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        return this.getFrame(streamInfo, buffer);
    }

    FrameInfo getFrameSharedMemory(StreamInfo profile, ByteBuffer buffer) {
        SharedMemoryHolder sharedMemoryHolder = (SharedMemoryHolder)this.mFrameTransferSharedMemoryMap.get(profile.getStreamType());
        if (sharedMemoryHolder == null) {
            throw new VisionServiceException("stream " + profile.getStreamType() + " not enabled");
        }
        try {
            FrameInfo frameInfo = this.mAprSenseAIDLService.getFrameMemoryFile(profile.getStreamType(), profile.getResolution(), profile.getPixelFormat());
            if (frameInfo == null) {
                return null;
            }
            try {
                buffer.rewind();
                FileInputStream inputStream = sharedMemoryHolder.inputStream;
                int n = inputStream.getChannel().position(0L).read(buffer);
            }
            catch (IOException e) {
                throw new VisionServiceException(e);
            }
            return frameInfo;
        }
        catch (RemoteException e) {
            throw new VisionServiceException("get Frame failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameInfo getFrame(StreamInfo profile, ByteBuffer buffer) {
        FrameInfo frameInfo;
        FrameClientThread frameClientThread;
        SparseArray<FrameClientThread> sparseArray = this.mFrameTransferMap;
        synchronized (sparseArray) {
            frameClientThread = (FrameClientThread)this.mFrameTransferMap.get(profile.getStreamType());
        }
        if (frameClientThread == null) {
            throw new VisionServiceException("frame transfer for stream " + profile.getStreamType() + " not started");
        }
        try {
            frameInfo = this.mAprSenseAIDLService.getFrame(profile.getStreamType(), profile.getResolution(), profile.getPixelFormat());
        }
        catch (RemoteException e) {
            throw new VisionServiceException("get Frame failed", e);
        }
        if (frameInfo == null) {
            return null;
        }
        int length = (int)(PixelFormat.getPixelBytes(profile.getPixelFormat()) * (float)profile.getHeight() * (float)profile.getWidth());
        frameClientThread.readFrame(buffer, length);
        FrameClientThread frameClientThread2 = frameClientThread;
        synchronized (frameClientThread2) {
            while (!frameClientThread.isTransferEnded()) {
                try {
                    frameClientThread.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!frameClientThread.isReadSuccess()) {
            Logger.e((String)TAG, (String)"read frame not success, check log for details");
            throw new VisionServiceException("read frame failed");
        }
        return frameInfo;
    }

    @Deprecated
    void startPersonDetection(PersonDetectCallback callback) {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.startPersonDetection();
            if (callback != null) {
                this.mPersonDetectCallback.add(callback);
            }
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    @Deprecated
    void stopPersonDetection() {
        this.checkConnected();
        this.checkAprSenseStarted();
        this.mPersonDetectCallback.clear();
        try {
            this.mAprSenseAIDLService.stopPersonDetection();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    void startDetectingPerson(PersonDetectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("PersonDetectListener can't be null!");
        }
        this.checkDtsStarted();
        try {
            this.mPersonDetectListener = listener;
            this.mAprSenseAIDLService.startDetectingPerson(this.mIPersonDetectionListener);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    void stopDetectingPerson() {
        this.checkAprSenseStarted();
        this.checkDtsStarted();
        this.mPersonDetectListener = null;
        try {
            this.mAprSenseAIDLService.stopDetectingPerson();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    @Deprecated
    void startPersonTracking(int personId) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.startPersonTracking(personId);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    @Deprecated
    void stopPersonTracking(int personId) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.stopPersonTracking(personId);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    @Deprecated
    List<Person> findPersons() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.findPersons();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    void loadPersonDatabase(String databasePath) {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.loadRecognitionDatabase(databasePath);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    void savePersonDatabase(String databasePath) {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.saveRecognitionDatabase(databasePath);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    long getAprSenseTimeStamp() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.getAprSenseTimeStamp();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("An exception occurs in getting the AprSense timestamp! ", e);
        }
    }

    float getDepthFocalLengthX() {
        try {
            return this.mAprSenseAIDLService.getFloatParam(501);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    float getDepthFocalLengthY() {
        try {
            return this.mAprSenseAIDLService.getFloatParam(502);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    float getDepthPrincipalPointX() {
        try {
            return this.mAprSenseAIDLService.getFloatParam(503);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    float getDepthPrincipalPointY() {
        try {
            return this.mAprSenseAIDLService.getFloatParam(504);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIMUDataCallback(IMUDataCallback callback) {
        this.checkConnected();
        List<IMUCallbackBundle> list = this.mIMUDataCallbacks;
        synchronized (list) {
            for (IMUCallbackBundle bundle : this.mIMUDataCallbacks) {
                if (bundle.callback != callback) continue;
                return;
            }
            IMUCallbackBundle bundle = new IMUCallbackBundle();
            bundle.callback = callback;
            bundle.buffer = ByteBuffer.allocateDirect(800);
            this.mIMUDataCallbacks.add(bundle);
            if (this.mIMUDataCallbacks.size() == 1) {
                try {
                    this.mAprSenseAIDLService.setIMUDataCallback(this.mIImuDataCallback);
                }
                catch (RemoteException e) {
                    throw new VisionServiceException("add IMU Data Callback exception! ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIMUDataCallback(IMUDataCallback callback) {
        this.checkConnected();
        List<IMUCallbackBundle> list = this.mIMUDataCallbacks;
        synchronized (list) {
            IMUCallbackBundle removeBundle = null;
            for (IMUCallbackBundle bundle : this.mIMUDataCallbacks) {
                this.mIMUDataCallbacks.remove(callback);
                if (bundle.callback != callback) continue;
                removeBundle = bundle;
                break;
            }
            if (removeBundle != null) {
                this.mIMUDataCallbacks.remove(removeBundle);
            }
            if (this.mIMUDataCallbacks.size() == 0) {
                try {
                    this.mAprSenseAIDLService.removeIMUDataCallback();
                }
                catch (RemoteException e) {
                    throw new VisionServiceException("An exception occurs in removing the IMU Data callback! ", e);
                }
            }
        }
    }

    byte[] getCalibrationData() {
        this.checkConnected();
        try {
            return this.mAprSenseAIDLService.getCalibrationData();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get calibration data failed", e);
        }
    }

    ColorDepthCalibration getColorDepthCalibrationData() {
        this.checkConnected();
        try {
            return this.mAprSenseAIDLService.getColorDepthCalibrationData();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get calibration data failed", e);
        }
    }

    MotionModuleCalibration getMotionModuleCalibrationData() {
        this.checkConnected();
        try {
            return this.mAprSenseAIDLService.getMotionModuleCalibrationData();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get calibration data failed", e);
        }
    }

    boolean isFishEyeAutoExposureEnabled() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.isFishEyeAutoExposureEnabled();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get fish eye camera auto exposure enable state error", e);
        }
    }

    void enableFishEyeAutoExposure(boolean enable) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.enableFishEyeAutoExposure(enable);
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Set fish eye camera auto exposure enable/disable state error", e);
        }
    }

    float getFishEyeEvCompensation() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.getFishEyeEvCompensation();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get fish eye camera EV compensation error", e);
        }
    }

    void setFishEyeEvCompensation(float compensation) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.setFishEyeEvCompensation(compensation);
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Set fish eye camera EV compensation error", e);
        }
    }

    float getFishEyeManualExposure() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.getFishEyeManualExposure();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get fish eye camera manual exposure error", e);
        }
    }

    void setFishEyeManualExposure(float exposure) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.setFishEyeManualExposure(exposure);
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Set fish eye camera manual exposure error", e);
        }
    }

    float getFishEyeManualGain() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.getFishEyeManualGain();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get fish eye camera manual gain error", e);
        }
    }

    void setFishEyeManualGain(float gain) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.setFishEyeManualGain(gain);
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Set fish eye camera manual gain error", e);
        }
    }

    void setFishEyeAutoExposureROI(Rect rect) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.setFishEyeAutoExposureROI(rect);
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Set fish eye camera auto exposure ROI error", e);
        }
    }

    long getNanoDiffFromEpochToMotion() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.getNanoDiffFromEpochToMotion();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get nano diff from micro epoch to motion timestamp error", e);
        }
    }

    private void checkConnected() throws VisionServiceException {
        if (this.mAprSenseAIDLService == null) {
            throw VisionServiceException.getServiceNotConnectedException();
        }
    }

    private void checkAprSenseStarted() throws VisionServiceException {
        try {
            boolean started = this.mAprSenseAIDLService.isAprSenseRunning();
            if (!started) {
                throw VisionServiceException.getAprSenseNotStaredException();
            }
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    private void checkDtsStarted() {
        this.checkConnected();
        if (!this.mDTSEnabled.get()) {
            throw new IllegalStateException("Dts module is not started, please start dts first!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preview(int streamType, Surface surface, boolean drawPerson) throws VisionServiceException {
        this.checkConnected();
        SparseArray<Object> sparseArray = this.mPreviewMap;
        synchronized (sparseArray) {
            if (this.mPreviewMap.get(streamType) != null) {
                throw new VisionServiceException("Preview stream is duplicated.");
            }
            this.mPreviewMap.put(streamType, this.mDummy);
        }
        try {
            this.mAprSenseAIDLService.startPreview(streamType, surface, drawPerson);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPreview(int streamType) {
        this.checkConnected();
        SparseArray<Object> sparseArray = this.mPreviewMap;
        synchronized (sparseArray) {
            if (this.mPreviewMap.get(streamType) == null) {
                Logger.w((String)TAG, (String)("stopPreview: stream " + streamType + " did not start preview"));
                return;
            }
            this.mPreviewMap.remove(streamType);
        }
        try {
            this.mAprSenseAIDLService.stopPreview(streamType);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void enablePersonTrackingAndDetection(Surface mainCameraPreview) {
        this.checkConnected();
        if (this.mDTSEnabled.get()) {
            return;
        }
        try {
            this.mAprSenseAIDLService.enablePersonTrackingAndDetection(mainCameraPreview);
            this.mDTSEnabled.set(true);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void enablePersonTrackingAndDetection(Surface mainCameraPreview, int videoSource) {
        this.checkConnected();
        if (this.mDTSEnabled.get()) {
            return;
        }
        try {
            this.mAprSenseAIDLService.enablePersonTrackingAndDetection2(mainCameraPreview, videoSource);
            this.mDTSEnabled.set(true);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void disablePersonTrackingAndDetection() {
        this.checkConnected();
        if (!this.mDTSEnabled.get()) {
            return;
        }
        this.mDTSEnabled.set(false);
        try {
            this.mAprSenseAIDLService.disablePersonTrackingAndDetection();
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    DTSPerson[] detectPersons(long timeoutMicroSeconds) {
        if (timeoutMicroSeconds <= 0L) {
            throw new IllegalArgumentException("Timeout is illegal!");
        }
        this.checkDtsStarted();
        try {
            return this.mAprSenseAIDLService.detectPersons(timeoutMicroSeconds);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void startPersonTracking(DTSPerson person, long timeout, PersonTrackingListener listener) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout is illegal!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("PersonTrackingListener can't be null!");
        }
        this.checkDtsStarted();
        if (person == null) {
            person = new DTSPerson(0.0f, 0.0f, 0.0f, null, 0, 0, 0.0f, new Rect(0, 0, 640, 480), null, 0.0f, 0.0f, 0.0f, 0L);
        }
        this.mPersonTrackingListener = listener;
        try {
            this.mAprSenseAIDLService.startPersonTracking2(person, timeout, this.mIPersonTrackingListener);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void stopPersonTracking() {
        this.checkDtsStarted();
        try {
            this.mAprSenseAIDLService.stopPersonTracking2();
            this.mPersonTrackingListener = null;
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void startPlannerPersonTracking(DTSPerson person, long timeout, PersonTrackingWithPlannerListener listener) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout is illegal!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("PersonTrackingListener can't be null!");
        }
        this.checkDtsStarted();
        if (person == null) {
            person = new DTSPerson(0.0f, 0.0f, 0.0f, null, 0, 0, 0.0f, new Rect(0, 0, 640, 480), null, 0.0f, 0.0f, 0.0f, 0L);
        }
        this.mPlannerPersonTrackingListener = listener;
        try {
            this.mAprSenseAIDLService.startPlannerPersonTracking(person, timeout, this.mIPlannerPersonTackingListener);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void stopPlannerPersonTracking() {
        this.checkDtsStarted();
        try {
            this.mPlannerPersonTrackingListener = null;
            this.mAprSenseAIDLService.stopPlannerPersonTracking();
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void setPlannerTrackingConfig(PersonTrackingProfile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("Profile can't be null!");
        }
        this.checkDtsStarted();
        try {
            this.mAprSenseAIDLService.setPlannerTrackingConfig(profile);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void startGeneralTracking(DTSObject object, GeneralTrackingProfile profile, long timeout, GeneralTrackingListener listener) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout is illegal!");
        }
        if (listener == null) {
            throw new IllegalArgumentException("GeneralTrackingListener can't be null!");
        }
        this.checkDtsStarted();
        if (object == null) {
            object = new DTSObject(0.0f, 0.0f, 0.0f, null, 0, 0, 0.0f, new Rect(0, 0, 640, 480), null, 0.0f, 0.0f, 0L);
        }
        this.mGeneralTrackingListener = listener;
        try {
            this.mAprSenseAIDLService.startGeneralTracking(object, profile, timeout, this.mIGeneralTrackingListener);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    void stopGeneralTracking() {
        this.checkDtsStarted();
        try {
            this.mGeneralTrackingListener = null;
            this.mAprSenseAIDLService.stopGeneralTracking();
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    float getHWTemperature() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.getHWTemperature();
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyServiceConnected() {
        List<VisionServiceCallback> list = this.mVisionServiceCallbacks;
        synchronized (list) {
            for (VisionServiceCallback visionServiceCallback : this.mVisionServiceCallbacks) {
                visionServiceCallback.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyServiceDisconnected() {
        List<VisionServiceCallback> list = this.mVisionServiceCallbacks;
        synchronized (list) {
            for (VisionServiceCallback visionServiceCallback : this.mVisionServiceCallbacks) {
                visionServiceCallback.onServiceDisconnected();
            }
            this.mVisionServiceCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAprSenseStarted() {
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            for (AprSenseStateCallback aprSenseStateCallback : this.mAprSenseStateCallback) {
                aprSenseStateCallback.onAprSenseStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRealSenseStopped() {
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            for (AprSenseStateCallback aprSenseStateCallback : this.mAprSenseStateCallback) {
                aprSenseStateCallback.onAprSenseStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRealSenseError(int errorCode, String errorMsg) {
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            for (AprSenseStateCallback aprSenseStateCallback : this.mAprSenseStateCallback) {
                aprSenseStateCallback.onAprSenseError(errorCode, errorMsg);
            }
        }
    }

    Surface getSurface() {
        try {
            return this.mAprSenseAIDLService.getSurface();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    void setVideoSource(int videoSource) {
        try {
            this.mAprSenseAIDLService.setVideoSource(videoSource);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    void setPoseRecognitionEnabled(boolean enabled) {
        try {
            this.mAprSenseAIDLService.setPoseRecognitionEnabled(enabled);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    boolean isPoseRecognitionEnabled() {
        try {
            return this.mAprSenseAIDLService.isPoseRecognitionEnabled();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    public Version getVersion() {
        return new Version("STABLE", "0.6.227", 6000227, 600005);
    }

    protected void setAprSenseAIDLService(IAprSenseService aprSenseAIDLService) {
        this.mAprSenseAIDLService = aprSenseAIDLService;
    }

    private class SharedMemoryHolder {
        ParcelFileDescriptor parcelFileDescriptor;
        FileInputStream inputStream;

        private SharedMemoryHolder() {
        }
    }
}

