/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision;

import android.view.Surface;
import com.segway.robot.algo.dts.DTSPerson;
import com.segway.robot.algo.dts.PersonTrackingListener;
import com.segway.robot.sdk.vision.VisionServiceManager;

public class DTS {
    private int mVideoSource = 1;
    private Surface mSurface;
    private VisionServiceManager mVisionServiceManager;

    DTS(VisionServiceManager visionServiceManager) {
        this.mVisionServiceManager = visionServiceManager;
    }

    public void setVideoSource(int videoSource) {
        if (videoSource != 1) {
            throw new IllegalArgumentException("Only support camera video source now");
        }
        this.mVideoSource = videoSource;
    }

    public void setPreviewDisplay(Surface surface) {
        this.mSurface = surface;
    }

    public Surface getSurface() {
        return null;
    }

    public void start() {
        this.mVisionServiceManager.enablePersonTrackingAndDetection(this.mSurface);
    }

    public void stop() {
        this.mVisionServiceManager.disablePersonTrackingAndDetection();
    }

    public DTSPerson[] detectPersons(long timeoutMicroSeconds) {
        return this.mVisionServiceManager.detectPersons(timeoutMicroSeconds);
    }

    public void startPersonTracking(DTSPerson person, long timeout, PersonTrackingListener listener) {
        this.mVisionServiceManager.startPersonTracking(person, timeout, listener);
    }

    public void stopPersonTracking() {
        this.mVisionServiceManager.stopPersonTracking();
    }

    public final class VideoSource {
        public static final int CAMERA = 1;
        public static final int SURFACE = 2;

        private VideoSource() {
        }
    }
}

