package com.segway.robot.sdk.vision.internal.ipc;

import android.os.MemoryFile;
import android.os.ParcelFileDescriptor;

import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MemoryFileUtil {
    private static final Method sMethodGetFileDescriptor;
    private static final Constructor sConstructorCreateParcelFileDescriptor;

    static {
        sMethodGetFileDescriptor = get("getFileDescriptor");
        sConstructorCreateParcelFileDescriptor = getConstructor();
    }

    public static ParcelFileDescriptor createParcelFileDescriptor(FileDescriptor fileDescriptor) {
        try {
            return (ParcelFileDescriptor) sConstructorCreateParcelFileDescriptor.newInstance(fileDescriptor);
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileDescriptor getFileDescriptor(MemoryFile file) {
        try {
            return (FileDescriptor) sMethodGetFileDescriptor.invoke(file);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method get(String name) {
        try {
            return MemoryFile.class.getDeclaredMethod(name);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Constructor getConstructor() {
        Class c = ParcelFileDescriptor.class;
        for (Constructor constructor : c.getConstructors()) {
            Class[] params = constructor.getParameterTypes();
            if (params.length == 1 && params[0] == FileDescriptor.class) {
                return constructor;
            }
        }
        throw new RuntimeException("file descriptor not found");
    }
}
