package com.segway.robot.sdk.vision.internal.framebuffer;

/**
 * Created by ark338 on 16/6/22.
 */
public abstract class BaseFrame implements CountableFrame {
    int mLockCount = 0;
    long mTid;

    public BaseFrame() {
        mTid = System.currentTimeMillis();
    }

    public void reuse() {
        mTid = System.currentTimeMillis();
    }

    @Override
    public void lockCountUp() {
        mLockCount++;
    }

    @Override
    public void lockCountDown() {
        mLockCount--;
    }

    @Override
    public boolean isLocked() {
        return mLockCount > 0;
    }

    @Override
    public void release() {
        mLockCount = 0;
    }

    @Override
    public long getTid() {
        return mTid;
    }
}
