/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision;

import android.view.Surface;
import com.segway.robot.algo.dts.DTSPerson;
import com.segway.robot.algo.dts.PersonDetectListener;
import com.segway.robot.algo.dts.PersonTrackingListener;
import com.segway.robot.algo.dts.PersonTrackingWithPlannerListener;
import com.segway.robot.sdk.vision.VisionServiceManager;

public class DTS {
    private int mVideoSource = 0;
    private Surface mSurface;
    private VisionServiceManager mVisionServiceManager;
    private boolean isVideoSelected = false;

    DTS(VisionServiceManager visionServiceManager) {
        this.mVisionServiceManager = visionServiceManager;
    }

    public void setVideoSource(int videoSource) {
        if (videoSource != 2 && videoSource != 1) {
            throw new IllegalArgumentException("Illegal VideoSource mode!");
        }
        this.isVideoSelected = true;
        this.mVideoSource = videoSource;
    }

    public void setPreviewDisplay(Surface surface) {
        if (this.mVideoSource != 1) {
            throw new IllegalStateException("Only be supported in VideoSource.CAMERA mode!");
        }
        this.mSurface = surface;
    }

    public Surface getSurface() {
        switch (this.mVideoSource) {
            case 1: {
                return this.mSurface;
            }
            case 2: {
                return this.mVisionServiceManager.getSurface();
            }
        }
        return null;
    }

    public void start() {
        if (!this.isVideoSelected) {
            throw new IllegalStateException("Please set video source first!");
        }
        this.mVisionServiceManager.enablePersonTrackingAndDetection(this.mSurface, this.mVideoSource);
    }

    public void stop() {
        this.mVisionServiceManager.disablePersonTrackingAndDetection();
    }

    public void startDetectingPerson(PersonDetectListener listener) {
        this.mVisionServiceManager.startDetectingPerson(listener);
    }

    public void stopDetectingPerson() {
        this.mVisionServiceManager.stopDetectingPerson();
    }

    public DTSPerson[] detectPersons(long timeoutMicroSeconds) {
        return this.mVisionServiceManager.detectPersons(timeoutMicroSeconds);
    }

    public void startPersonTracking(DTSPerson person, long timeout, PersonTrackingListener listener) {
        this.mVisionServiceManager.startPersonTracking(person, timeout, listener);
    }

    public void stopPersonTracking() {
        this.mVisionServiceManager.stopPersonTracking();
    }

    public void setPoseRecognitionEnabled(boolean enabled) {
        this.mVisionServiceManager.setPoseRecognitionEnabled(enabled);
    }

    public boolean isPoseRecognitionEnabled() {
        return this.mVisionServiceManager.isPoseRecognitionEnabled();
    }

    public void startPlannerPersonTracking(DTSPerson person, long timeout, PersonTrackingWithPlannerListener listener) {
        this.mVisionServiceManager.startPlannerPersonTracking(person, timeout, listener);
    }

    public void stopPlannerPersonTracking() {
        this.mVisionServiceManager.stopPlannerPersonTracking();
    }

    public final class VideoSource {
        public static final int CAMERA = 1;
        public static final int SURFACE = 2;

        private VideoSource() {
        }
    }
}

