/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.framebuffer;

import android.util.SparseArray;
import com.segway.robot.sdk.base.time.StampedData;
import com.segway.robot.sdk.vision.frame.FrameInfo;
import com.segway.robot.sdk.vision.internal.framebuffer.BaseFrame;
import java.nio.ByteBuffer;
import java.util.Stack;

public class RecyclableFrame2
extends BaseFrame {
    static SparseArray<Stack<RecyclableFrame2>> mFramePool = new SparseArray();
    private int mStreamType;
    private int mIndex;
    private int mBufferSize;
    private FrameInfo mFrameInfo;
    private ByteBuffer mImageBuffer;
    private FrameReleaseHandler mReleaseHandler;

    private RecyclableFrame2(int streamType, int index, int bufferSize, FrameInfo frameInfo, ByteBuffer imageBuffer, FrameReleaseHandler releaseHandler) {
        this.mStreamType = streamType;
        this.mIndex = index;
        this.mBufferSize = bufferSize;
        this.mFrameInfo = frameInfo;
        this.mImageBuffer = imageBuffer;
        this.mReleaseHandler = releaseHandler;
    }

    public void reuse(int streamType, int index, int bufferSize, FrameInfo frameInfo, ByteBuffer imageBuffer, FrameReleaseHandler releaseHandler) {
        super.reuse();
        this.mStreamType = streamType;
        this.mIndex = index;
        this.mBufferSize = bufferSize;
        this.mFrameInfo = frameInfo;
        this.mImageBuffer = imageBuffer;
        this.mReleaseHandler = releaseHandler;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.mImageBuffer.rewind();
        return this.mImageBuffer;
    }

    @Override
    public FrameInfo getInfo() {
        return this.mFrameInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.mReleaseHandler.releaseFrame(this.mStreamType, this.mIndex);
        this.mReleaseHandler = null;
        Class<RecyclableFrame2> clazz = RecyclableFrame2.class;
        synchronized (RecyclableFrame2.class) {
            super.release();
            ((Stack)mFramePool.get(this.mBufferSize)).push(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized RecyclableFrame2 create(int streamType, int index, int bufferSize, FrameInfo frameInfo, ByteBuffer imageBuffer, FrameReleaseHandler releaseHandler) {
        if (mFramePool.get(bufferSize) == null) {
            mFramePool.put(bufferSize, new Stack());
        }
        if (((Stack)mFramePool.get(bufferSize)).empty()) {
            return new RecyclableFrame2(streamType, index, bufferSize, frameInfo, imageBuffer, releaseHandler);
        }
        RecyclableFrame2 recyclableFrame = (RecyclableFrame2)((Stack)mFramePool.get(bufferSize)).pop();
        recyclableFrame.reuse(streamType, index, bufferSize, frameInfo, imageBuffer, releaseHandler);
        return recyclableFrame;
    }

    public long getTimestamp() {
        return this.mFrameInfo.getIMUTimeStamp();
    }

    public long diff(StampedData source) {
        return source.getTimestamp() - this.getTimestamp();
    }

    public static interface FrameReleaseHandler {
        public void releaseFrame(int var1, int var2);
    }
}

