/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision;

import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.Surface;
import com.segway.robot.algo.dts.DTSPerson;
import com.segway.robot.algo.dts.IPersonDetectionListener;
import com.segway.robot.algo.dts.IPersonTrackingListener;
import com.segway.robot.algo.dts.IPlannerPersonTackingListener;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.vision.IAprSenseServiceCallback;
import com.segway.robot.sdk.vision.calibration.ColorDepthCalibration;
import com.segway.robot.sdk.vision.calibration.MotionModuleCalibration;
import com.segway.robot.sdk.vision.frame.FrameInfo;
import com.segway.robot.sdk.vision.imu.IIMUDataCallback;
import com.segway.robot.sdk.vision.internal.ipc.MemoryFileBufferCallback;
import com.segway.robot.sdk.vision.person.FindPersonsHandler;
import com.segway.robot.sdk.vision.person.Person;
import com.segway.robot.sdk.vision.stream.StreamInfo;
import java.util.ArrayList;
import java.util.List;

public interface IAprSenseService
extends IInterface {
    public void startAprSense() throws RemoteException;

    public void stopAprSense() throws RemoteException;

    public boolean isAprSenseRunning() throws RemoteException;

    public void addCallback(IAprSenseServiceCallback var1) throws RemoteException;

    public void enableStream(int var1, int var2, int var3, int var4) throws RemoteException;

    public void cleanStreams() throws RemoteException;

    public StreamInfo[] getActivatedStreamProfile() throws RemoteException;

    public void startPreview(int var1, Surface var2, boolean var3) throws RemoteException;

    public void stopPreview(int var1) throws RemoteException;

    public String setupImageTransferSocket(int var1, int var2) throws RemoteException;

    public void stopImageTransfer(int var1, int var2) throws RemoteException;

    public void addFindPersonHandler(FindPersonsHandler var1) throws RemoteException;

    public void startPersonDetection() throws RemoteException;

    public void stopPersonDetection() throws RemoteException;

    public void startPersonTracking(int var1) throws RemoteException;

    public void stopPersonTracking(int var1) throws RemoteException;

    public List<Person> findPersons() throws RemoteException;

    public void loadRecognitionDatabase(String var1) throws RemoteException;

    public void saveRecognitionDatabase(String var1) throws RemoteException;

    public long getAprSenseTimeStamp() throws RemoteException;

    public void setIMUDataCallback(IIMUDataCallback var1) throws RemoteException;

    public void removeIMUDataCallback() throws RemoteException;

    public FrameInfo getFrame(int var1, int var2, int var3) throws RemoteException;

    public FrameInfo getFrameMemoryFile(int var1, int var2, int var3) throws RemoteException;

    public ParcelFileDescriptor setupImageTransferSharedMemory(int var1, int var2) throws RemoteException;

    public float getFloatParam(int var1) throws RemoteException;

    public byte[] getCalibrationData() throws RemoteException;

    public Version getVersion() throws RemoteException;

    public ColorDepthCalibration getColorDepthCalibrationData() throws RemoteException;

    public MotionModuleCalibration getMotionModuleCalibrationData() throws RemoteException;

    public boolean isFishEyeAutoExposureEnabled() throws RemoteException;

    public void enableFishEyeAutoExposure(boolean var1) throws RemoteException;

    public float getFishEyeEvCompensation() throws RemoteException;

    public void setFishEyeEvCompensation(float var1) throws RemoteException;

    public float getFishEyeManualExposure() throws RemoteException;

    public void setFishEyeManualExposure(float var1) throws RemoteException;

    public float getFishEyeManualGain() throws RemoteException;

    public void setFishEyeManualGain(float var1) throws RemoteException;

    public void setFishEyeAutoExposureROI(Rect var1) throws RemoteException;

    public void startImageTransferMemoryFileBuffer(int var1, MemoryFileBufferCallback var2) throws RemoteException;

    public void stopImageTransferMemoryFileBuffer(int var1) throws RemoteException;

    public void releaseMemoryFileBuffer(int var1, int var2) throws RemoteException;

    public void registerClient(IBinder var1, String var2) throws RemoteException;

    public void unregisterClient(String var1) throws RemoteException;

    public long getNanoDiffFromEpochToMotion() throws RemoteException;

    public void enablePersonTrackingAndDetection(Surface var1) throws RemoteException;

    public void disablePersonTrackingAndDetection() throws RemoteException;

    public DTSPerson[] detectPersons(long var1) throws RemoteException;

    public void startPersonTracking2(DTSPerson var1, long var2, IPersonTrackingListener var4) throws RemoteException;

    public void stopPersonTracking2() throws RemoteException;

    public float getHWTemperature() throws RemoteException;

    public void setVideoSource(int var1) throws RemoteException;

    public Surface getSurface() throws RemoteException;

    public void startDetectingPerson(IPersonDetectionListener var1) throws RemoteException;

    public void stopDetectingPerson() throws RemoteException;

    public void enablePersonTrackingAndDetection2(Surface var1, int var2) throws RemoteException;

    public void setPoseRecognitionEnabled(boolean var1) throws RemoteException;

    public boolean isPoseRecognitionEnabled() throws RemoteException;

    public void startPlannerPersonTracking(DTSPerson var1, long var2, IPlannerPersonTackingListener var4) throws RemoteException;

    public void stopPlannerPersonTracking() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAprSenseService {
        private static final String DESCRIPTOR = "com.segway.robot.sdk.vision.IAprSenseService";
        static final int TRANSACTION_startAprSense = 1;
        static final int TRANSACTION_stopAprSense = 2;
        static final int TRANSACTION_isAprSenseRunning = 3;
        static final int TRANSACTION_addCallback = 4;
        static final int TRANSACTION_enableStream = 5;
        static final int TRANSACTION_cleanStreams = 6;
        static final int TRANSACTION_getActivatedStreamProfile = 7;
        static final int TRANSACTION_startPreview = 8;
        static final int TRANSACTION_stopPreview = 9;
        static final int TRANSACTION_setupImageTransferSocket = 10;
        static final int TRANSACTION_stopImageTransfer = 11;
        static final int TRANSACTION_addFindPersonHandler = 12;
        static final int TRANSACTION_startPersonDetection = 13;
        static final int TRANSACTION_stopPersonDetection = 14;
        static final int TRANSACTION_startPersonTracking = 15;
        static final int TRANSACTION_stopPersonTracking = 16;
        static final int TRANSACTION_findPersons = 17;
        static final int TRANSACTION_loadRecognitionDatabase = 18;
        static final int TRANSACTION_saveRecognitionDatabase = 19;
        static final int TRANSACTION_getAprSenseTimeStamp = 20;
        static final int TRANSACTION_setIMUDataCallback = 21;
        static final int TRANSACTION_removeIMUDataCallback = 22;
        static final int TRANSACTION_getFrame = 23;
        static final int TRANSACTION_getFrameMemoryFile = 24;
        static final int TRANSACTION_setupImageTransferSharedMemory = 25;
        static final int TRANSACTION_getFloatParam = 26;
        static final int TRANSACTION_getCalibrationData = 27;
        static final int TRANSACTION_getVersion = 28;
        static final int TRANSACTION_getColorDepthCalibrationData = 29;
        static final int TRANSACTION_getMotionModuleCalibrationData = 30;
        static final int TRANSACTION_isFishEyeAutoExposureEnabled = 31;
        static final int TRANSACTION_enableFishEyeAutoExposure = 32;
        static final int TRANSACTION_getFishEyeEvCompensation = 33;
        static final int TRANSACTION_setFishEyeEvCompensation = 34;
        static final int TRANSACTION_getFishEyeManualExposure = 35;
        static final int TRANSACTION_setFishEyeManualExposure = 36;
        static final int TRANSACTION_getFishEyeManualGain = 37;
        static final int TRANSACTION_setFishEyeManualGain = 38;
        static final int TRANSACTION_setFishEyeAutoExposureROI = 39;
        static final int TRANSACTION_startImageTransferMemoryFileBuffer = 40;
        static final int TRANSACTION_stopImageTransferMemoryFileBuffer = 41;
        static final int TRANSACTION_releaseMemoryFileBuffer = 42;
        static final int TRANSACTION_registerClient = 43;
        static final int TRANSACTION_unregisterClient = 44;
        static final int TRANSACTION_getNanoDiffFromEpochToMotion = 45;
        static final int TRANSACTION_enablePersonTrackingAndDetection = 46;
        static final int TRANSACTION_disablePersonTrackingAndDetection = 47;
        static final int TRANSACTION_detectPersons = 48;
        static final int TRANSACTION_startPersonTracking2 = 49;
        static final int TRANSACTION_stopPersonTracking2 = 50;
        static final int TRANSACTION_getHWTemperature = 51;
        static final int TRANSACTION_setVideoSource = 52;
        static final int TRANSACTION_getSurface = 53;
        static final int TRANSACTION_startDetectingPerson = 54;
        static final int TRANSACTION_stopDetectingPerson = 55;
        static final int TRANSACTION_enablePersonTrackingAndDetection2 = 56;
        static final int TRANSACTION_setPoseRecognitionEnabled = 57;
        static final int TRANSACTION_isPoseRecognitionEnabled = 58;
        static final int TRANSACTION_startPlannerPersonTracking = 59;
        static final int TRANSACTION_stopPlannerPersonTracking = 60;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAprSenseService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAprSenseService) {
                return (IAprSenseService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    this.startAprSense();
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopAprSense();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isAprSenseRunning();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    IAprSenseServiceCallback _arg0 = IAprSenseServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.addCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.enableStream(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    this.cleanStreams();
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    Parcelable[] _result = this.getActivatedStreamProfile();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    Surface _arg1 = 0 != data.readInt() ? (Surface)Surface.CREATOR.createFromParcel(data) : null;
                    boolean _arg2 = 0 != data.readInt();
                    this.startPreview(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.stopPreview(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _result = this.setupImageTransferSocket(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.stopImageTransfer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    FindPersonsHandler _arg0 = FindPersonsHandler.Stub.asInterface(data.readStrongBinder());
                    this.addFindPersonHandler(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    this.startPersonDetection();
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopPersonDetection();
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.startPersonTracking(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.stopPersonTracking(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    List _result = this.findPersons();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.loadRecognitionDatabase(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.saveRecognitionDatabase(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    long _result = this.getAprSenseTimeStamp();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    IIMUDataCallback _arg0 = IIMUDataCallback.Stub.asInterface(data.readStrongBinder());
                    this.setIMUDataCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    this.removeIMUDataCallback();
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    FrameInfo _result = this.getFrame(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    FrameInfo _result = this.getFrameMemoryFile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ParcelFileDescriptor _result = this.setupImageTransferSharedMemory(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    float _result = this.getFloatParam(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    byte[] _result = this.getCalibrationData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    Version _result = this.getVersion();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 29: {
                    data.enforceInterface(DESCRIPTOR);
                    ColorDepthCalibration _result = this.getColorDepthCalibrationData();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 30: {
                    data.enforceInterface(DESCRIPTOR);
                    MotionModuleCalibration _result = this.getMotionModuleCalibrationData();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 31: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isFishEyeAutoExposureEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    this.enableFishEyeAutoExposure(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface(DESCRIPTOR);
                    float _result = this.getFishEyeEvCompensation();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 34: {
                    data.enforceInterface(DESCRIPTOR);
                    float _arg0 = data.readFloat();
                    this.setFishEyeEvCompensation(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(DESCRIPTOR);
                    float _result = this.getFishEyeManualExposure();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 36: {
                    data.enforceInterface(DESCRIPTOR);
                    float _arg0 = data.readFloat();
                    this.setFishEyeManualExposure(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface(DESCRIPTOR);
                    float _result = this.getFishEyeManualGain();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 38: {
                    data.enforceInterface(DESCRIPTOR);
                    float _arg0 = data.readFloat();
                    this.setFishEyeManualGain(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface(DESCRIPTOR);
                    Rect _arg0 = 0 != data.readInt() ? (Rect)Rect.CREATOR.createFromParcel(data) : null;
                    this.setFishEyeAutoExposureROI(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    MemoryFileBufferCallback _arg1 = MemoryFileBufferCallback.Stub.asInterface(data.readStrongBinder());
                    this.startImageTransferMemoryFileBuffer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 41: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.stopImageTransferMemoryFileBuffer(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 42: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.releaseMemoryFileBuffer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 43: {
                    data.enforceInterface(DESCRIPTOR);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    this.registerClient(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.unregisterClient(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface(DESCRIPTOR);
                    long _result = this.getNanoDiffFromEpochToMotion();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 46: {
                    data.enforceInterface(DESCRIPTOR);
                    Surface _arg0 = 0 != data.readInt() ? (Surface)Surface.CREATOR.createFromParcel(data) : null;
                    this.enablePersonTrackingAndDetection(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 47: {
                    data.enforceInterface(DESCRIPTOR);
                    this.disablePersonTrackingAndDetection();
                    reply.writeNoException();
                    return true;
                }
                case 48: {
                    data.enforceInterface(DESCRIPTOR);
                    long _arg0 = data.readLong();
                    DTSPerson[] _result = this.detectPersons(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray((Parcelable[])_result, 1);
                    return true;
                }
                case 49: {
                    data.enforceInterface(DESCRIPTOR);
                    DTSPerson _arg0 = 0 != data.readInt() ? (DTSPerson)DTSPerson.CREATOR.createFromParcel(data) : null;
                    long _arg1 = data.readLong();
                    IPersonTrackingListener _arg2 = IPersonTrackingListener.Stub.asInterface(data.readStrongBinder());
                    this.startPersonTracking2(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopPersonTracking2();
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(DESCRIPTOR);
                    float _result = this.getHWTemperature();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 52: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.setVideoSource(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(DESCRIPTOR);
                    Surface _result = this.getSurface();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 54: {
                    data.enforceInterface(DESCRIPTOR);
                    IPersonDetectionListener _arg0 = IPersonDetectionListener.Stub.asInterface(data.readStrongBinder());
                    this.startDetectingPerson(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopDetectingPerson();
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface(DESCRIPTOR);
                    Surface _arg0 = 0 != data.readInt() ? (Surface)Surface.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.enablePersonTrackingAndDetection2(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0 = 0 != data.readInt();
                    this.setPoseRecognitionEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 58: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isPoseRecognitionEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 59: {
                    data.enforceInterface(DESCRIPTOR);
                    DTSPerson _arg0 = 0 != data.readInt() ? (DTSPerson)DTSPerson.CREATOR.createFromParcel(data) : null;
                    long _arg1 = data.readLong();
                    IPlannerPersonTackingListener _arg2 = IPlannerPersonTackingListener.Stub.asInterface(data.readStrongBinder());
                    this.startPlannerPersonTracking(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 60: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopPlannerPersonTracking();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IAprSenseService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void startAprSense() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopAprSense() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAprSenseRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCallback(IAprSenseServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableStream(int streamType, int resolution, int fps, int pixerformat) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(resolution);
                    _data.writeInt(fps);
                    _data.writeInt(pixerformat);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void cleanStreams() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StreamInfo[] getActivatedStreamProfile() throws RemoteException {
                StreamInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = (StreamInfo[])_reply.createTypedArray(StreamInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPreview(int streamType, Surface surface, boolean showPerson) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(showPerson ? 1 : 0);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPreview(int streamType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String setupImageTransferSocket(int streamType, int transferType) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(transferType);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopImageTransfer(int streamType, int transferType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(transferType);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addFindPersonHandler(FindPersonsHandler handler) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(handler != null ? handler.asBinder() : null);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void startPersonDetection() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopPersonDetection() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPersonTracking(int personId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(personId);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPersonTracking(int personId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(personId);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Person> findPersons() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Person.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loadRecognitionDatabase(String database) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(database);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void saveRecognitionDatabase(String database) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(database);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAprSenseTimeStamp() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIMUDataCallback(IIMUDataCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void removeIMUDataCallback() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FrameInfo getFrame(int streamType, int resolution, int pixelFormat) throws RemoteException {
                FrameInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(resolution);
                    _data.writeInt(pixelFormat);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (FrameInfo)FrameInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FrameInfo getFrameMemoryFile(int streamType, int resolution, int pixelFormat) throws RemoteException {
                FrameInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(resolution);
                    _data.writeInt(pixelFormat);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (FrameInfo)FrameInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor setupImageTransferSharedMemory(int streamType, int transferType) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(transferType);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParcelFileDescriptor)ParcelFileDescriptor.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getFloatParam(int paramID) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(paramID);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getCalibrationData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Version getVersion() throws RemoteException {
                Version _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Version)Version.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ColorDepthCalibration getColorDepthCalibrationData() throws RemoteException {
                ColorDepthCalibration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ColorDepthCalibration)ColorDepthCalibration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MotionModuleCalibration getMotionModuleCalibrationData() throws RemoteException {
                MotionModuleCalibration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (MotionModuleCalibration)MotionModuleCalibration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFishEyeAutoExposureEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableFishEyeAutoExposure(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getFishEyeEvCompensation() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFishEyeEvCompensation(float compensation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(compensation);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getFishEyeManualExposure() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFishEyeManualExposure(float exposure) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(exposure);
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getFishEyeManualGain() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFishEyeManualGain(float gain) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(gain);
                    this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFishEyeAutoExposureROI(Rect rect) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (rect != null) {
                        _data.writeInt(1);
                        rect.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startImageTransferMemoryFileBuffer(int streamType, MemoryFileBufferCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopImageTransferMemoryFileBuffer(int streamType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseMemoryFileBuffer(int streamType, int index) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(index);
                    this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClient(IBinder ibinder, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(ibinder);
                    _data.writeString(packageName);
                    this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterClient(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getNanoDiffFromEpochToMotion() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enablePersonTrackingAndDetection(Surface surface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void disablePersonTrackingAndDetection() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DTSPerson[] detectPersons(long timeoutMicroSeconds) throws RemoteException {
                DTSPerson[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeoutMicroSeconds);
                    this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = (DTSPerson[])_reply.createTypedArray(DTSPerson.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPersonTracking2(DTSPerson person, long timeout, IPersonTrackingListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (person != null) {
                        _data.writeInt(1);
                        person.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeLong(timeout);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopPersonTracking2() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getHWTemperature() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVideoSource(int videoSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(videoSource);
                    this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Surface getSurface() throws RemoteException {
                Surface _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Surface)Surface.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDetectingPerson(IPersonDetectionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopDetectingPerson() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enablePersonTrackingAndDetection2(Surface surface, int videoSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(videoSource);
                    this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPoseRecognitionEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPoseRecognitionEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPlannerPersonTracking(DTSPerson person, long timeout, IPlannerPersonTackingListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (person != null) {
                        _data.writeInt(1);
                        person.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeLong(timeout);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopPlannerPersonTracking() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

