/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.ipc;

import android.os.MemoryFile;
import android.os.ParcelFileDescriptor;
import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MemoryFileUtil {
    private static final Method sMethodGetFileDescriptor = MemoryFileUtil.get("getFileDescriptor");
    private static final Constructor sConstructorCreateParcelFileDescriptor = MemoryFileUtil.getConstructor();

    public static ParcelFileDescriptor createParcelFileDescriptor(FileDescriptor fileDescriptor) {
        try {
            return (ParcelFileDescriptor)sConstructorCreateParcelFileDescriptor.newInstance(fileDescriptor);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileDescriptor getFileDescriptor(MemoryFile file) {
        try {
            return (FileDescriptor)sMethodGetFileDescriptor.invoke((Object)file, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method get(String name) {
        try {
            return MemoryFile.class.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Constructor getConstructor() {
        Class<ParcelFileDescriptor> c = ParcelFileDescriptor.class;
        for (Constructor<?> constructor : c.getConstructors()) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != 1 || params[0] != FileDescriptor.class) continue;
            return constructor;
        }
        throw new RuntimeException("file descriptor not found");
    }
}

