package com.segway.robot.sdk.vision.stream;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * the supported stream types.
 * Note: the definition must not be above 16383, because AprSenseService keeps only 14 bits for this.
 */
public interface StreamType {
    /**
     * a color image stream.
     */
    int COLOR = 1;

    /**
     * a depth image stream.
     */
    int DEPTH = 2;

    /**
     * a left image stream.
     */
    int LEFT = 8;

    /**
     * a right image stream.
     */
    int RIGHT = 16;

    /**
     * a fish eye image stream.
     */
    int FISH_EYE = 256;

    /**
     * a slam map image, not supported now.
     */
    int SLAM_MAP = 512;

    @IntDef(flag = true, value = {
            COLOR, DEPTH, FISH_EYE, SLAM_MAP})
    @Retention(RetentionPolicy.SOURCE)
    @interface VisionStreamTypes {}

    @IntDef(flag = false, value = {
            COLOR, DEPTH, FISH_EYE})
    @Retention(RetentionPolicy.SOURCE)
    @interface VisionStreamType {}

    @IntDef(flag = false, value = {
            COLOR, DEPTH, FISH_EYE})
    @Retention(RetentionPolicy.SOURCE)
    @interface VisionStreamTypeAdvanced {}
}
