/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.frame;

import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;

public class FrameInfo
implements Parcelable {
    public static final int SIZE = 60;
    int streamType;
    int resolution;
    int pixelFormat;
    int intArg0;
    int intArg1;
    int intArg2;
    int intArg3;
    int intArg4;
    int intArg5;
    int intArg6;
    int intArg7;
    long longArg0;
    long longArg1;
    ByteBuffer mByteBuffer;
    public static final Parcelable.Creator<FrameInfo> CREATOR = new Parcelable.Creator<FrameInfo>(){

        public FrameInfo createFromParcel(Parcel in) {
            int streamType = in.readInt();
            int resolution = in.readInt();
            int pixelFormat = in.readInt();
            FrameInfo frameInfo = new FrameInfo(streamType, resolution, pixelFormat);
            frameInfo.intArg0 = in.readInt();
            frameInfo.intArg1 = in.readInt();
            frameInfo.intArg2 = in.readInt();
            frameInfo.intArg3 = in.readInt();
            frameInfo.intArg4 = in.readInt();
            frameInfo.intArg5 = in.readInt();
            frameInfo.intArg6 = in.readInt();
            frameInfo.intArg7 = in.readInt();
            frameInfo.longArg0 = in.readLong();
            frameInfo.longArg1 = in.readLong();
            return frameInfo;
        }

        public FrameInfo[] newArray(int size) {
            return new FrameInfo[size];
        }
    };

    public FrameInfo() {
    }

    public FrameInfo(int streamType, int resolution, int pixelFormat) {
        this.streamType = streamType;
        this.resolution = resolution;
        this.pixelFormat = pixelFormat;
    }

    public FrameInfo(FrameInfo frameInfo) {
        this.streamType = frameInfo.getStreamType();
        this.resolution = frameInfo.getResolution();
        this.pixelFormat = frameInfo.getPixelFormat();
        this.intArg0 = frameInfo.intArg0;
        this.intArg1 = frameInfo.intArg1;
        this.intArg2 = frameInfo.intArg2;
        this.intArg3 = frameInfo.intArg3;
        this.intArg4 = frameInfo.intArg4;
        this.intArg5 = frameInfo.intArg5;
        this.intArg6 = frameInfo.intArg6;
        this.intArg7 = frameInfo.intArg7;
        this.longArg0 = frameInfo.longArg0;
        this.longArg1 = frameInfo.longArg1;
    }

    public void setStreamType(int streamType) {
        this.streamType = streamType;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public int getStreamType() {
        return this.streamType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void setStride(int stride) {
        this.intArg0 = stride;
    }

    public void setFrameNum(int frameNum) {
        this.intArg1 = frameNum;
    }

    public void setExposure(int exposure) {
        this.intArg2 = exposure;
    }

    public void setPlatformTimeStamp(long timeStamp) {
        this.longArg1 = timeStamp;
    }

    public long getPlatformTimeStamp() {
        return this.longArg1;
    }

    public void setIMUTimeStamp(long timeStamp) {
        this.longArg0 = timeStamp;
    }

    public long getIMUTimeStamp() {
        return this.longArg0;
    }

    public synchronized ByteBuffer toByteBuffer() {
        if (this.mByteBuffer == null) {
            this.mByteBuffer = ByteBuffer.allocate(60);
        }
        this.mByteBuffer.rewind();
        this.mByteBuffer.putInt(this.streamType);
        this.mByteBuffer.putInt(this.resolution);
        this.mByteBuffer.putInt(this.pixelFormat);
        this.mByteBuffer.putInt(this.intArg0);
        this.mByteBuffer.putInt(this.intArg1);
        this.mByteBuffer.putInt(this.intArg2);
        this.mByteBuffer.putInt(this.intArg3);
        this.mByteBuffer.putInt(this.intArg4);
        this.mByteBuffer.putInt(this.intArg5);
        this.mByteBuffer.putInt(this.intArg6);
        this.mByteBuffer.putInt(this.intArg7);
        this.mByteBuffer.putLong(this.longArg0);
        this.mByteBuffer.putLong(this.longArg1);
        this.mByteBuffer.rewind();
        return this.mByteBuffer;
    }

    public static FrameInfo fromByteBuffer(ByteBuffer buffer) {
        FrameInfo frameInfo = new FrameInfo();
        buffer.rewind();
        frameInfo.streamType = buffer.getInt();
        frameInfo.resolution = buffer.getInt();
        frameInfo.pixelFormat = buffer.getInt();
        frameInfo.intArg0 = buffer.getInt();
        frameInfo.intArg1 = buffer.getInt();
        frameInfo.intArg2 = buffer.getInt();
        frameInfo.intArg3 = buffer.getInt();
        frameInfo.intArg4 = buffer.getInt();
        frameInfo.intArg5 = buffer.getInt();
        frameInfo.intArg6 = buffer.getInt();
        frameInfo.intArg7 = buffer.getInt();
        frameInfo.longArg0 = buffer.getLong();
        frameInfo.longArg1 = buffer.getLong();
        return frameInfo;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.streamType);
        dest.writeInt(this.resolution);
        dest.writeInt(this.pixelFormat);
        dest.writeInt(this.intArg0);
        dest.writeInt(this.intArg1);
        dest.writeInt(this.intArg2);
        dest.writeInt(this.intArg3);
        dest.writeInt(this.intArg4);
        dest.writeInt(this.intArg5);
        dest.writeInt(this.intArg6);
        dest.writeInt(this.intArg7);
        dest.writeLong(this.longArg0);
        dest.writeLong(this.longArg1);
    }

    public String toString() {
        return "FrameInfo: type:" + this.streamType + " resolution:" + this.resolution + " pixel format:" + this.pixelFormat + " frame number:" + this.intArg1 + " timestamp:" + this.longArg0;
    }
}

