package com.segway.robot.sdk.vision.frame;

/**
 * Depth frame information
 */
public class DepthFrameInfo {
    FrameInfo mFrameInfo;

    public DepthFrameInfo(int streamType, int resolution, int pixelFormat,
                          int stride, int frameNum, long timeStamp) {
        mFrameInfo = new FrameInfo(streamType, resolution, pixelFormat);
        mFrameInfo.intArg0 = stride;
        mFrameInfo.intArg1 = frameNum;
        mFrameInfo.longArg0 = timeStamp;
    }

    public DepthFrameInfo(FrameInfo frameInfo) {
        this.mFrameInfo = frameInfo;
    }

    public int getStride() {
        return mFrameInfo.intArg0;
    }

    public int getFrameNum() {
        return mFrameInfo.intArg1;
    }

    public long getTimeStamp() {
        return mFrameInfo.longArg0;
    }

    public void setTimeStamp(long timeStamp) {
        mFrameInfo.longArg0 = timeStamp;
    }

    public FrameInfo getFrameInfo() {
        return mFrameInfo;
    }
}
