/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.framebuffer;

import android.util.SparseArray;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.base.time.StampedData;
import com.segway.robot.sdk.vision.frame.FrameInfo;
import com.segway.robot.sdk.vision.internal.framebuffer.BaseFrame;
import com.segway.robot.sdk.vision.stream.Resolution;
import java.nio.ByteBuffer;
import java.util.Stack;

public class RecyclableFrame
extends BaseFrame {
    static SparseArray<Stack<RecyclableFrame>> mFramePool = new SparseArray();
    ByteBuffer mByteBuffer;
    FrameInfo mFrameInfo;
    private int mBufferSize;

    private RecyclableFrame(int bufferSize, FrameInfo frameInfo) {
        this.mBufferSize = bufferSize;
        this.mFrameInfo = frameInfo;
        this.mByteBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public void reuse(FrameInfo frameInfo) {
        super.reuse();
        this.mFrameInfo = frameInfo;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.mByteBuffer.rewind();
        return this.mByteBuffer;
    }

    @Override
    public FrameInfo getInfo() {
        return this.mFrameInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Class<RecyclableFrame> clazz = RecyclableFrame.class;
        synchronized (RecyclableFrame.class) {
            super.release();
            ((Stack)mFramePool.get(this.mBufferSize)).push(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized RecyclableFrame create(int bufferSize, FrameInfo frameInfo) {
        if (mFramePool.get(bufferSize) == null) {
            mFramePool.put(bufferSize, new Stack());
        }
        if (((Stack)mFramePool.get(bufferSize)).empty()) {
            return new RecyclableFrame(bufferSize, frameInfo);
        }
        RecyclableFrame recyclableFrame = (RecyclableFrame)((Stack)mFramePool.get(bufferSize)).pop();
        recyclableFrame.reuse(frameInfo);
        return recyclableFrame;
    }

    public long getTimestamp() {
        return this.mFrameInfo.getIMUTimeStamp();
    }

    public long diff(StampedData source) {
        return source.getTimestamp() - this.getTimestamp();
    }

    public static RecyclableFrame packFrame(ByteBuffer frame, long timestamp, int streamType, long num, int width, int height, int bytesPerPixel, int pixelFormat) {
        int realSize;
        int imageSize = frame.capacity();
        if (imageSize != (realSize = width * height * bytesPerPixel)) {
            Logger.e((String)"RecyclableFrame", (String)("jniOnNewFrame->right imageSize = " + imageSize + "; realSize=" + realSize));
            return null;
        }
        int resolution = Resolution.toVisionServiceResolution(width, height);
        FrameInfo frameInfo = new FrameInfo(streamType, resolution, pixelFormat);
        frameInfo.setFrameNum((int)num);
        frameInfo.setPlatformTimeStamp(timestamp);
        frameInfo.setExposure(0);
        frameInfo.setStride(0);
        RecyclableFrame recyclableFrame = RecyclableFrame.create(imageSize, frameInfo);
        recyclableFrame.getByteBuffer().put(frame);
        return recyclableFrame;
    }
}

