/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.person;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.sdk.vision.person.Point3DF;
import com.segway.robot.sdk.vision.tools.DataWithConfidence;

public class Person
implements Parcelable {
    private int m_id;
    private DataWithConfidence<Rect> m_boundingRect;
    private DataWithConfidence<PointF> m_imageMassCenter;
    private DataWithConfidence<Point3DF> m_worldMassCenter;
    public static final Parcelable.Creator<Person> CREATOR = new Parcelable.Creator<Person>(){

        public Person createFromParcel(Parcel in) {
            return new Person(in);
        }

        public Person[] newArray(int size) {
            return new Person[size];
        }
    };

    public Person(int id, DataWithConfidence<Rect> boundingRect, DataWithConfidence<PointF> image, DataWithConfidence<Point3DF> world) {
        this.m_id = id;
        this.m_boundingRect = boundingRect;
        this.m_imageMassCenter = image;
        this.m_worldMassCenter = world;
    }

    public int getId() {
        return this.m_id;
    }

    public DataWithConfidence<Rect> getBounds() {
        return this.m_boundingRect;
    }

    public DataWithConfidence<PointF> getImageMassCenter() {
        return this.m_imageMassCenter;
    }

    public DataWithConfidence<Point3DF> getWorldMassCenter() {
        return this.m_worldMassCenter;
    }

    public void drawFaceRect(Bitmap bitmap) {
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        Rect rect = (Rect)this.m_boundingRect.data;
        paint.setColor(-16711936);
        paint.setTextSize(30.0f);
        paint.setStrokeWidth(5.0f);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawRect(rect, paint);
        canvas.drawText(Integer.toString(this.m_id), (float)rect.left, (float)(rect.top + 15), paint);
    }

    protected Person(Parcel in) {
        this.m_id = in.readInt();
        this.m_boundingRect = (DataWithConfidence)in.readParcelable(DataWithConfidence.class.getClassLoader());
        this.m_imageMassCenter = (DataWithConfidence)in.readParcelable(DataWithConfidence.class.getClassLoader());
        this.m_worldMassCenter = (DataWithConfidence)in.readParcelable(DataWithConfidence.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.m_id);
        dest.writeParcelable(this.m_boundingRect, flags);
        dest.writeParcelable(this.m_imageMassCenter, flags);
        dest.writeParcelable(this.m_worldMassCenter, flags);
    }
}

