package com.segway.robot.sdk.vision.calibration;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.vision.basic.Matrix3F;

/**
 * Camera Intrinsic
 */

public class Intrinsic2 implements Parcelable{
    public Matrix3F kf = new Matrix3F();
    public Distortion distortion = new Distortion();

    public Intrinsic2() {
    }

    protected Intrinsic2(Parcel in) {
        kf = in.readParcelable(Matrix3F.class.getClassLoader());
        distortion = in.readParcelable(Distortion.class.getClassLoader());
    }

    public static final Creator<Intrinsic2> CREATOR = new Creator<Intrinsic2>() {
        @Override
        public Intrinsic2 createFromParcel(Parcel in) {
            return new Intrinsic2(in);
        }

        @Override
        public Intrinsic2[] newArray(int size) {
            return new Intrinsic2[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(kf, flags);
        dest.writeParcelable(distortion, flags);
    }

    @Override
    public String toString() {
        return "Intrinsic2{" +
                "\nkf:\n" + kf +
                "\ndistortion:\n" + distortion +
                "\n}";
    }
}
