/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.imu;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.Switchers;
import com.segway.robot.sdk.vision.calibration.RS2Intrinsic;
import com.segway.robot.sdk.vision.imu.IIMUDataCallback;
import com.segway.robot.sdk.vision.imu.IIMUSensor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class IMUSensor
implements IIMUSensor,
Handler.Callback {
    private static String TAG = IMUSensor.class.getSimpleName();
    private SensorManager mSensorManager;
    private static final int MAX_FRAME = 10;
    private static final int FRAME_LENGTH = 48;
    private static final int TYPE_GYR = 1;
    private static final int TYPE_ACC = 2;
    private final ByteBuffer mByteBufferEvents;
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private Context mContext;
    private volatile int mIntCursor = 0;
    private volatile AtomicLong mLongSequence = new AtomicLong(0L);
    private Sensor mSensorAcc;
    private Sensor mSensorGyr;
    public static final int ADD_IMU = 5;
    public static final int REMOVE_IMU = 6;
    public static final int NOTIFY_IMU = 7;
    public static final int OPEN_IMU = 8;
    public static final int CLOSE_IMU = 9;
    private SensorEventListener mSensorEventListenerACC;
    private SensorEventListener mSensorEventListenerGyr;
    private Handler mIMUHandler = null;
    private Handler mHandlerACC = null;
    private Handler mHandlerGyr = null;
    private final SparseArray<IIMUDataCallback> mIMUMap = new SparseArray();

    private IMUSensor(@NonNull Context context) {
        this.mContext = context;
        this.mByteBufferEvents = ByteBuffer.allocate(480);
        this.mByteBufferEvents.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static IMUSensor newInstance(Context context) {
        return new IMUSensor(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            if (this.mIMUHandler == null) {
                HandlerThread thread = new HandlerThread("imu_callback");
                thread.start();
                this.mIMUHandler = new Handler(thread.getLooper(), (Handler.Callback)this);
                HandlerThread threadAcc = new HandlerThread("imu_acc");
                HandlerThread threadGyr = new HandlerThread("imu_gyr");
                threadAcc.start();
                threadGyr.start();
                this.mHandlerACC = new Handler(threadAcc.getLooper());
                this.mHandlerGyr = new Handler(threadGyr.getLooper());
            }
        }
        this.mIMUHandler.sendEmptyMessage(8);
    }

    private void doOpen() {
        Logger.i((String)TAG, (String)("doOpen() isFisheyeOpen()=" + this.isOpen.get()));
        if (this.isOpen.get()) {
            Logger.w((String)TAG, (String)"open: IMUSensor is already open.");
            return;
        }
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        if (this.mSensorManager == null) {
            Log.e((String)TAG, (String)"IMUSensor: sensorManager is null.");
            return;
        }
        this.mSensorAcc = this.mSensorManager.getDefaultSensor(1);
        this.mSensorGyr = this.mSensorManager.getDefaultSensor(4);
        this.mSensorEventListenerACC = new SensorEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSensorChanged(SensorEvent event) {
                if (Switchers.isRecording) {
                    Logger.d((String)TAG, (String)("imu== type: 2 timestamp: " + event.timestamp + " diff=" + (System.currentTimeMillis() - event.timestamp / 1000000L)));
                }
                ByteBuffer byteBuffer = IMUSensor.this.mByteBufferEvents;
                synchronized (byteBuffer) {
                    IMUSensor.this.inflateIMUFrame(event, 2);
                    if (IMUSensor.this.mIntCursor == 9) {
                        IMUSensor.this.callNotifyIMUData();
                    } else {
                        IMUSensor.this.mIntCursor++;
                    }
                }
            }

            public void onAccuracyChanged(Sensor sensor, int accuracy) {
                Log.d((String)TAG, (String)"onAccuracyChanged: ");
            }
        };
        this.mSensorEventListenerGyr = new SensorEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSensorChanged(SensorEvent event) {
                if (Switchers.isRecording) {
                    Logger.d((String)TAG, (String)("imu== type: 1 timestamp: " + event.timestamp + " diff=" + (System.currentTimeMillis() - event.timestamp / 1000000L)));
                }
                ByteBuffer byteBuffer = IMUSensor.this.mByteBufferEvents;
                synchronized (byteBuffer) {
                    IMUSensor.this.inflateIMUFrame(event, 1);
                    if (IMUSensor.this.mIntCursor == 9) {
                        IMUSensor.this.callNotifyIMUData();
                    } else {
                        IMUSensor.this.mIntCursor++;
                    }
                }
            }

            public void onAccuracyChanged(Sensor sensor, int accuracy) {
            }
        };
        this.mSensorManager.registerListener(this.mSensorEventListenerACC, this.mSensorAcc, 4807, this.mHandlerACC);
        this.mSensorManager.registerListener(this.mSensorEventListenerGyr, this.mSensorGyr, 4807, this.mHandlerGyr);
        Logger.d((String)TAG, (String)"open: registerListeners.");
        this.isOpen.set(true);
    }

    private void doClose() {
        Log.i((String)TAG, (String)("doClose: isFisheyeOpen()=" + this.isOpen.get()));
        if (!this.isOpen.get()) {
            Logger.w((String)TAG, (String)"release: IMUSensor is not open.");
            return;
        }
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener(this.mSensorEventListenerACC);
            this.mSensorManager.unregisterListener(this.mSensorEventListenerGyr);
            Logger.d((String)TAG, (String)"release: unregisterListeners.");
        }
        this.mSensorManager = null;
        this.mSensorAcc = null;
        this.mSensorGyr = null;
        this.mSensorEventListenerGyr = null;
        this.mSensorEventListenerACC = null;
        this.isOpen.set(false);
        this.mIMUMap.clear();
        this.mIMUHandler.removeCallbacksAndMessages(null);
        this.mIMUHandler.getLooper().quit();
        this.mIMUHandler = null;
    }

    private void callNotifyIMUData() {
        this.mIntCursor = 0;
        byte[] resBytes = new byte[this.mByteBufferEvents.capacity()];
        this.mByteBufferEvents.get(resBytes);
        ByteBuffer resBuffer = ByteBuffer.wrap(resBytes);
        Message msg = Message.obtain();
        msg.what = 7;
        msg.obj = resBuffer;
        msg.arg1 = 48;
        msg.arg2 = 10;
        this.mIMUHandler.sendMessage(msg);
        this.mByteBufferEvents.clear();
    }

    private void inflateIMUFrame(SensorEvent event, int type) {
        int frameOffset = this.mIntCursor * 48;
        this.mByteBufferEvents.putLong(frameOffset, event.timestamp);
        this.mByteBufferEvents.putLong(frameOffset + 8, this.mIntCursor);
        this.mByteBufferEvents.putInt(frameOffset + 16, type);
        this.mByteBufferEvents.putFloat(frameOffset + 24, event.values[0]);
        this.mByteBufferEvents.putFloat(frameOffset + 28, event.values[1]);
        this.mByteBufferEvents.putFloat(frameOffset + 32, event.values[2]);
        this.mByteBufferEvents.putLong(frameOffset + 40, event.timestamp / 1000L);
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public void release() {
        if (this.mIMUHandler != null) {
            this.mIMUHandler.sendEmptyMessage(9);
        }
    }

    @Override
    public synchronized boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public void addIMUDataCallback(int pid, IIMUDataCallback.Stub callback) {
        if (this.mIMUHandler != null) {
            this.mIMUHandler.sendMessage(this.mIMUHandler.obtainMessage(5, pid, pid, (Object)callback));
        }
    }

    @Override
    public void removeIMUDataCallback(int pid) {
        if (this.mIMUHandler != null) {
            this.mIMUHandler.sendMessage(this.mIMUHandler.obtainMessage(6, pid, pid));
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Log.w((String)TAG, (String)("finalize: " + this.getClass().getSimpleName()));
    }

    @Override
    public RS2Intrinsic getRS2Intrinsic() {
        return null;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 5: {
                this.mIMUMap.put(msg.arg1, (Object)((IIMUDataCallback)msg.obj));
                break;
            }
            case 6: {
                this.mIMUMap.remove(msg.arg1);
                break;
            }
            case 8: {
                this.doOpen();
                break;
            }
            case 9: {
                this.doClose();
                break;
            }
            case 7: {
                this.notifyIMUData(msg);
                break;
            }
        }
        return true;
    }

    private void notifyIMUData(Message msg) {
        for (int i = 0; i < this.mIMUMap.size(); ++i) {
            IIMUDataCallback callback = (IIMUDataCallback)this.mIMUMap.valueAt(i);
            try {
                if (callback == null) continue;
                callback.onNewData(((ByteBuffer)msg.obj).array(), msg.arg1, msg.arg2);
                continue;
            }
            catch (RemoteException e) {
                Logger.e((String)TAG, (String)"notifyIMUData: remote exception.");
                this.mIMUMap.removeAt(i);
                break;
            }
        }
    }
}

