/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.stream;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.stream.StreamInfo;

public class ExtDepthStreamFactory {
    private static final String TAG = "ExtDepthStreamFactory";

    public static StreamInfo createExtDepthConfig(int config, int type) {
        if (type != 64 && type != 32) {
            Logger.e((String)TAG, (String)"ext depth stream type is illegal!");
            throw new IllegalArgumentException("ext depth stream type is illegal!");
        }
        switch (config) {
            case 10: {
                return StreamInfo.create(type, 564658416, 30, 2);
            }
            case 11: {
                return StreamInfo.create(type, 564658416, 15, 2);
            }
            case 12: {
                return StreamInfo.create(type, 564658416, 6, 2);
            }
            case 13: {
                return StreamInfo.create(type, 568328462, 30, 2);
            }
            case 14: {
                return StreamInfo.create(type, 568328462, 15, 2);
            }
            case 15: {
                return StreamInfo.create(type, 568328462, 6, 2);
            }
            case 16: {
                return StreamInfo.create(type, 578027988, 6, 6);
            }
            case 17: {
                return StreamInfo.create(type, 620757712, 6, 6);
            }
            case 0: {
                Logger.w((String)TAG, (String)"createExtDepthConfig: CONFIG_NONE is not supported now!");
                return null;
            }
        }
        Logger.w((String)TAG, (String)"createExtDepthConfig: none config");
        return null;
    }

    public static StreamInfo createExtIRConfig(int config, int type) {
        if (type != 1024 && type != 2048) {
            Logger.e((String)TAG, (String)"ext IR stream type is illegal.");
            throw new IllegalArgumentException("ext IR stream type is illegal!");
        }
        switch (config) {
            case 10: {
                return StreamInfo.create(type, 564658416, 30, 6);
            }
            case 11: {
                return StreamInfo.create(type, 564658416, 15, 6);
            }
            case 12: {
                return StreamInfo.create(type, 564658416, 6, 6);
            }
            case 13: {
                return StreamInfo.create(type, 568328462, 30, 6);
            }
            case 14: {
                return StreamInfo.create(type, 568328462, 15, 6);
            }
            case 15: {
                return StreamInfo.create(type, 568328462, 6, 6);
            }
            case 16: {
                return StreamInfo.create(type, 578027988, 6, 6);
            }
            case 0: {
                Logger.w((String)TAG, (String)"createExtDepthConfig: CONFIG_NONE is not supported now!");
                return null;
            }
        }
        Logger.w((String)TAG, (String)"createExtDepthConfig: none config");
        return null;
    }
}

