/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.socket;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.ImageStreamCallback;
import com.segway.robot.sdk.vision.frame.FrameInfo;
import com.segway.robot.sdk.vision.internal.framebuffer.FrameBuffer;
import com.segway.robot.sdk.vision.internal.framebuffer.RecyclableFrame;
import com.segway.robot.sdk.vision.stream.StreamInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class ImageReaderThreadManager {
    private static final String TAG = "ImageReaderThreadManage";
    private Map<Integer, Thread> mWorkThreadMap = new HashMap<Integer, Thread>();
    private static ImageReaderThreadManager mInstance;

    private ImageReaderThreadManager() {
    }

    public static synchronized ImageReaderThreadManager getInstance() {
        if (mInstance == null) {
            mInstance = new ImageReaderThreadManager();
        }
        return mInstance;
    }

    public synchronized void addConnection(final StreamInfo streamInfo, String address, final ImageStreamCallback callback) throws IOException {
        final LocalSocket localSocket = new LocalSocket();
        try {
            localSocket.connect(new LocalSocketAddress(address));
            final InputStream inputStream = localSocket.getInputStream();
            Thread workThread = new Thread("Image Transfer Thread, Type:" + streamInfo.getStreamType()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int bufferLength = (int)(streamInfo.getPixelBytes() * (float)streamInfo.getHeight() * (float)streamInfo.getWidth());
                    ByteBuffer frameInfoBuffer = ByteBuffer.allocate(60);
                    ByteBuffer imageBuffer = ByteBuffer.allocate(bufferLength);
                    try {
                        while (!this.isInterrupted()) {
                            try {
                                int cnt;
                                int len;
                                frameInfoBuffer.rewind();
                                for (cnt = 0; cnt < 60 && !this.isInterrupted() && (len = inputStream.read(frameInfoBuffer.array(), cnt, 60 - cnt)) != -1; cnt += len) {
                                }
                                imageBuffer.rewind();
                                for (cnt = 0; cnt < bufferLength && !this.isInterrupted() && (len = inputStream.read(imageBuffer.array(), cnt, bufferLength - cnt)) != -1; cnt += len) {
                                }
                                FrameInfo frameInfo = FrameInfo.fromByteBuffer(frameInfoBuffer);
                                callback.onNewImage(frameInfo, imageBuffer);
                            }
                            catch (IOException e) {
                                Logger.v((String)ImageReaderThreadManager.TAG, (String)("socket exception:" + e.getMessage()));
                                break;
                            }
                        }
                    }
                    finally {
                        try {
                            localSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            this.mWorkThreadMap.put(streamInfo.getStreamType(), workThread);
            workThread.start();
        }
        catch (IOException e) {
            Logger.e((String)TAG, (String)"connect socket error!", (Throwable)e);
            throw e;
        }
    }

    public synchronized void addConnection(final StreamInfo streamInfo, String address, final FrameBuffer frameBuffer) throws IOException {
        final LocalSocket localSocket = new LocalSocket();
        try {
            localSocket.connect(new LocalSocketAddress(address));
            final InputStream inputStream = localSocket.getInputStream();
            Thread workThread = new Thread("Image Transfer Thread, Type:" + streamInfo.getStreamType()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ByteBuffer frameInfoBuffer = ByteBuffer.allocate(60);
                    int imageSize = (int)(streamInfo.getPixelBytes() * (float)streamInfo.getWidth() * (float)streamInfo.getHeight());
                    try {
                        while (!this.isInterrupted()) {
                            try {
                                int len;
                                int cnt;
                                int len2;
                                frameInfoBuffer.rewind();
                                for (cnt = 0; cnt < 60 && !this.isInterrupted() && (len2 = inputStream.read(frameInfoBuffer.array(), cnt, 60 - cnt)) != -1; cnt += len2) {
                                }
                                FrameInfo frameInfo = FrameInfo.fromByteBuffer(frameInfoBuffer);
                                RecyclableFrame recyclableFrame = RecyclableFrame.create(imageSize, frameInfo);
                                ByteBuffer imageBuffer = recyclableFrame.getByteBuffer();
                                imageBuffer.rewind();
                                for (cnt = 0; cnt < imageSize && !this.isInterrupted() && (len = inputStream.read(imageBuffer.array(), cnt, imageSize - cnt)) != -1; cnt += len) {
                                }
                                imageBuffer.rewind();
                                frameBuffer.add(recyclableFrame);
                            }
                            catch (IOException e) {
                                Logger.v((String)ImageReaderThreadManager.TAG, (String)("socket exception:" + e.getMessage()));
                                break;
                            }
                        }
                    }
                    finally {
                        try {
                            localSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            this.mWorkThreadMap.put(streamInfo.getStreamType(), workThread);
            workThread.start();
        }
        catch (IOException e) {
            Logger.e((String)TAG, (String)"connect socket error!", (Throwable)e);
            throw e;
        }
    }

    public synchronized void removeConnection(StreamInfo streamInfo) {
        Thread workThread = this.mWorkThreadMap.get(streamInfo.getStreamType());
        if (workThread != null) {
            workThread.interrupt();
            this.mWorkThreadMap.remove(streamInfo.getStreamType());
        }
    }
}

