package com.segway.robot.sdk.vision.internal.framebuffer;

import android.util.Log;
import android.util.SparseArray;

import com.segway.robot.sdk.base.time.StampedData;
import com.segway.robot.sdk.vision.frame.FrameInfo;

import java.nio.ByteBuffer;
import java.util.Stack;

import static android.content.ContentValues.TAG;

/**
 * Recyclable frame
 */
public class RecyclableFrame2 extends BaseFrame {
    static SparseArray<Stack<RecyclableFrame2>> mFramePool = new SparseArray<>();
    private int mStreamType;
    private int mIndex;
    private int mBufferSize;
    private FrameInfo mFrameInfo;
    private ByteBuffer mImageBuffer;
    private FrameReleaseHandler mReleaseHandler;

    private RecyclableFrame2(int streamType, int index, int bufferSize,
                             FrameInfo frameInfo, ByteBuffer imageBuffer,
                             FrameReleaseHandler releaseHandler) {
        super();
        mStreamType = streamType;
        mIndex = index;
        mBufferSize = bufferSize;
        mFrameInfo = frameInfo;
        mImageBuffer = imageBuffer;
        mReleaseHandler = releaseHandler;
    }

    public void reuse(int streamType, int index, int bufferSize,
                      FrameInfo frameInfo, ByteBuffer imageBuffer,
                      FrameReleaseHandler releaseHandler) {
        super.reuse();
        mStreamType = streamType;
        mIndex = index;
        mBufferSize = bufferSize;
        mFrameInfo = frameInfo;
        mImageBuffer = imageBuffer;
        mReleaseHandler = releaseHandler;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        mImageBuffer.rewind();
        return mImageBuffer;
    }

    @Override
    public FrameInfo getInfo() {
        return mFrameInfo;
    }

    @Override
    public void release() {
        mReleaseHandler.releaseFrame(mStreamType, mIndex);
        mReleaseHandler = null;
        synchronized (RecyclableFrame2.class) {
            super.release();
            mFramePool.get(mBufferSize).push(this);
        }
    }

    public synchronized static RecyclableFrame2 create(int streamType, int index, int bufferSize,
                                                       FrameInfo frameInfo, ByteBuffer imageBuffer,
                                                       FrameReleaseHandler releaseHandler) {
        if (mFramePool.get(bufferSize) == null) {
            mFramePool.put(bufferSize, new Stack<RecyclableFrame2>());
        }

        if (mFramePool.get(bufferSize).empty()) {
            return new RecyclableFrame2(streamType, index, bufferSize, frameInfo, imageBuffer, releaseHandler);
        }

        RecyclableFrame2 recyclableFrame = mFramePool.get(bufferSize).pop();
        recyclableFrame.reuse(streamType, index, bufferSize, frameInfo, imageBuffer, releaseHandler);
        return recyclableFrame;
    }

    @Override
    public long getTimestamp() {
        return mFrameInfo.getIMUTimeStamp();
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - getTimestamp();
    }

    public interface FrameReleaseHandler {
        void releaseFrame(int streamType, int index);
    }
}
