package com.segway.robot.sdk.vision.frame;

import com.segway.robot.sdk.base.time.StampedData;

import java.nio.ByteBuffer;

/**
 * Created by ark338 on 16/6/22.
 */
public interface Frame extends StampedData{
    /**
     * get Tid of current frame
     * This method is for internal use only
     * @return Tid in long
     */
    long getTid();

    /**
     * get ByteBuffer of this Frame
     * @return ByteBuffer instance
     */
    ByteBuffer getByteBuffer();

    /**
     * get FrameInfo of this Frame
     * @return FrameInfo instance
     */
    FrameInfo getInfo();
}
