package com.segway.robot.sdk.vision.frame;

import android.os.Parcel;
import android.os.Parcelable;

import java.nio.ByteBuffer;

/**
 * Information of frame
 */
public class FrameInfo implements Parcelable {
    public static final int SIZE = 60;

    int streamType;
    int resolution;
    int pixelFormat;

    int intArg0;
    int intArg1;
    int intArg2;
    int intArg3;
    int intArg4;
    int intArg5;
    int intArg6;
    int intArg7;

    long longArg0;
    long longArg1;

    ByteBuffer mByteBuffer;

    public FrameInfo() {}

    public FrameInfo(int streamType, int resolution, int pixelFormat) {
        this.streamType = streamType;
        this.resolution = resolution;
        this.pixelFormat = pixelFormat;
    }

    public FrameInfo(FrameInfo frameInfo) {
        this.streamType = frameInfo.getStreamType();
        this.resolution = frameInfo.getResolution();
        this.pixelFormat = frameInfo.getPixelFormat();

        this.intArg0 = frameInfo.intArg0;
        this.intArg1 = frameInfo.intArg1;
        this.intArg2 = frameInfo.intArg2;
        this.intArg3 = frameInfo.intArg3;
        this.intArg4 = frameInfo.intArg4;
        this.intArg5 = frameInfo.intArg5;
        this.intArg6 = frameInfo.intArg6;
        this.intArg7 = frameInfo.intArg7;

        this.longArg0 = frameInfo.longArg0;
        this.longArg1 = frameInfo.longArg1;
    }

    public void setStreamType(int streamType) {
        this.streamType = streamType;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public int getStreamType() {
        return streamType;
    }

    public int getResolution() {
        return resolution;
    }

    public int getPixelFormat() {
        return pixelFormat;
    }

    public void setStride(int stride) {
        intArg0 = stride;
    }

    public void setFrameNum(int frameNum) {
        intArg1 = frameNum;
    }

    public void setExposure(int exposure) {
        intArg2 = exposure;
    }

    public void setIMUTimeStamp(long timeStamp) {
        longArg0 = timeStamp;
    }

    public long getIMUTimeStamp() {
        return longArg0;
    }

    public synchronized ByteBuffer toByteBuffer() {
        if (mByteBuffer == null) {
            mByteBuffer = ByteBuffer.allocate(SIZE);
        }

        mByteBuffer.rewind();
        mByteBuffer.putInt(streamType);
        mByteBuffer.putInt(resolution);
        mByteBuffer.putInt(pixelFormat);

        mByteBuffer.putInt(intArg0);
        mByteBuffer.putInt(intArg1);
        mByteBuffer.putInt(intArg2);
        mByteBuffer.putInt(intArg3);
        mByteBuffer.putInt(intArg4);
        mByteBuffer.putInt(intArg5);
        mByteBuffer.putInt(intArg6);
        mByteBuffer.putInt(intArg7);

        mByteBuffer.putLong(longArg0);
        mByteBuffer.putLong(longArg1);
        mByteBuffer.rewind();

        return mByteBuffer;
    }

    public static FrameInfo fromByteBuffer(ByteBuffer buffer) {
        FrameInfo frameInfo = new FrameInfo();

        buffer.rewind();
        frameInfo.streamType = buffer.getInt();
        frameInfo.resolution = buffer.getInt();
        frameInfo.pixelFormat = buffer.getInt();

        frameInfo.intArg0 = buffer.getInt();
        frameInfo.intArg1 = buffer.getInt();
        frameInfo.intArg2 = buffer.getInt();
        frameInfo.intArg3 = buffer.getInt();
        frameInfo.intArg4 = buffer.getInt();
        frameInfo.intArg5 = buffer.getInt();
        frameInfo.intArg6 = buffer.getInt();
        frameInfo.intArg7 = buffer.getInt();

        frameInfo.longArg0 = buffer.getLong();
        frameInfo.longArg1 = buffer.getLong();

        return frameInfo;
    }

    /**
     * Create from Parcel
     */
    public static final Creator<FrameInfo> CREATOR = new Creator<FrameInfo>() {
        @Override
        public FrameInfo createFromParcel(Parcel in) {
            int streamType = in.readInt();
            int resolution = in.readInt();
            int pixelFormat = in.readInt();

            FrameInfo frameInfo = new FrameInfo(streamType, resolution, pixelFormat);
            frameInfo.intArg0 = in.readInt();
            frameInfo.intArg1 = in.readInt();
            frameInfo.intArg2 = in.readInt();
            frameInfo.intArg3 = in.readInt();
            frameInfo.intArg4 = in.readInt();
            frameInfo.intArg5 = in.readInt();
            frameInfo.intArg6 = in.readInt();
            frameInfo.intArg7 = in.readInt();
            frameInfo.longArg0 = in.readLong();
            frameInfo.longArg1 = in.readLong();

            return frameInfo;
        }

        @Override
        public FrameInfo[] newArray(int size) {
            return new FrameInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(streamType);
        dest.writeInt(resolution);
        dest.writeInt(pixelFormat);
        dest.writeInt(intArg0);
        dest.writeInt(intArg1);
        dest.writeInt(intArg2);
        dest.writeInt(intArg3);
        dest.writeInt(intArg4);
        dest.writeInt(intArg5);
        dest.writeInt(intArg6);
        dest.writeInt(intArg7);
        dest.writeLong(longArg0);
        dest.writeLong(longArg1);
    }
}
