/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.socket;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import com.segway.robot.sdk.vision.ImageStreamCallback;
import com.segway.robot.sdk.vision.internal.frame.BaseFrameInfo;
import com.segway.robot.sdk.vision.internal.frame.FrameBuffer;
import com.segway.robot.sdk.vision.internal.frame.RecyclableFrame;
import com.segway.robot.sdk.vision.stream.StreamProfile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import timber.log.Timber;

public class ImageReaderThreadManager {
    private Map<Integer, Thread> mWorkThreadMap = new HashMap<Integer, Thread>();
    private static ImageReaderThreadManager mInstance;

    private ImageReaderThreadManager() {
    }

    public static synchronized ImageReaderThreadManager getInstance() {
        if (mInstance == null) {
            mInstance = new ImageReaderThreadManager();
        }
        return mInstance;
    }

    public synchronized void addConnection(final StreamProfile streamProfile, String address, final ImageStreamCallback callback) throws IOException {
        final LocalSocket localSocket = new LocalSocket();
        try {
            localSocket.connect(new LocalSocketAddress(address));
            final InputStream inputStream = localSocket.getInputStream();
            Thread workThread = new Thread("Image Transfer Thread, Type:" + streamProfile.getStreamType()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int bufferLength = (int)(streamProfile.getPixelBytes() * (float)streamProfile.getHeight() * (float)streamProfile.getWidth());
                    ByteBuffer frameInfoBuffer = ByteBuffer.allocate(60);
                    ByteBuffer imageBuffer = ByteBuffer.allocate(bufferLength);
                    try {
                        while (!this.isInterrupted()) {
                            try {
                                int cnt;
                                int len;
                                frameInfoBuffer.rewind();
                                for (cnt = 0; cnt < 60 && !this.isInterrupted() && (len = inputStream.read(frameInfoBuffer.array(), cnt, 60 - cnt)) != -1; cnt += len) {
                                }
                                imageBuffer.rewind();
                                for (cnt = 0; cnt < bufferLength && !this.isInterrupted() && (len = inputStream.read(imageBuffer.array(), cnt, bufferLength - cnt)) != -1; cnt += len) {
                                }
                                BaseFrameInfo baseFrameInfo = BaseFrameInfo.fromByteBuffer(frameInfoBuffer);
                                callback.onNewImage(baseFrameInfo, imageBuffer);
                            }
                            catch (IOException e) {
                                Timber.d((String)("socket exception:" + e.getMessage()), (Object[])new Object[0]);
                                break;
                            }
                        }
                    }
                    finally {
                        try {
                            localSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            this.mWorkThreadMap.put(streamProfile.getStreamType(), workThread);
            workThread.start();
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"connect socket error!", (Object[])new Object[0]);
            throw e;
        }
    }

    public synchronized void addConnection(final StreamProfile streamProfile, String address, final FrameBuffer frameBuffer) throws IOException {
        final LocalSocket localSocket = new LocalSocket();
        try {
            localSocket.connect(new LocalSocketAddress(address));
            final InputStream inputStream = localSocket.getInputStream();
            Thread workThread = new Thread("Image Transfer Thread, Type:" + streamProfile.getStreamType()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ByteBuffer frameInfoBuffer = ByteBuffer.allocate(60);
                    int imageSize = (int)(streamProfile.getPixelBytes() * (float)streamProfile.getWidth() * (float)streamProfile.getHeight());
                    try {
                        while (!this.isInterrupted()) {
                            try {
                                int len;
                                int cnt;
                                int len2;
                                frameInfoBuffer.rewind();
                                for (cnt = 0; cnt < 60 && !this.isInterrupted() && (len2 = inputStream.read(frameInfoBuffer.array(), cnt, 60 - cnt)) != -1; cnt += len2) {
                                }
                                BaseFrameInfo baseFrameInfo = BaseFrameInfo.fromByteBuffer(frameInfoBuffer);
                                RecyclableFrame recyclableFrame = RecyclableFrame.create(imageSize, baseFrameInfo);
                                ByteBuffer imageBuffer = recyclableFrame.getByteBuffer();
                                imageBuffer.rewind();
                                for (cnt = 0; cnt < imageSize && !this.isInterrupted() && (len = inputStream.read(imageBuffer.array(), cnt, imageSize - cnt)) != -1; cnt += len) {
                                }
                                imageBuffer.rewind();
                                frameBuffer.add(recyclableFrame);
                            }
                            catch (IOException e) {
                                Timber.d((String)("socket exception:" + e.getMessage()), (Object[])new Object[0]);
                                break;
                            }
                        }
                    }
                    finally {
                        try {
                            localSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            this.mWorkThreadMap.put(streamProfile.getStreamType(), workThread);
            workThread.start();
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"connect socket error!", (Object[])new Object[0]);
            throw e;
        }
    }

    public synchronized void removeConnection(StreamProfile streamProfile) {
        Thread workThread = this.mWorkThreadMap.get(streamProfile.getStreamType());
        if (workThread != null) {
            workThread.interrupt();
            this.mWorkThreadMap.remove(streamProfile.getStreamType());
        }
    }
}

