/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.socket;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.segway.robot.sdk.vision.stream.StreamProfile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import timber.log.Timber;

public class FrameClientThread {
    private static final int CONNECT = 0;
    private static final int READ = 1;
    final int MAX_RETRY = 5;
    final long INTERVAL = 500L;
    StreamProfile mStreamProfile;
    String mServerAddress;
    boolean isConnected;
    LocalSocket mLocalSocket;
    boolean isConnectFailed;
    boolean isTransferEnded;
    boolean isReadSuccess;
    ReadableByteChannel mReadableByteChannel;
    HandlerThread mHandlerThread;
    Handler mHandler;

    public FrameClientThread(StreamProfile mStreamProfile) {
        this.mStreamProfile = mStreamProfile;
        this.mHandlerThread = new HandlerThread("Read Frame Thread " + mStreamProfile.getStreamType());
        this.mHandlerThread.start();
        this.mHandler = new WorkHandler(this.mHandlerThread.getLooper());
    }

    public void connectServer(String address) {
        this.mServerAddress = address;
        this.mHandler.sendEmptyMessage(0);
    }

    public void disconnect() {
        if (this.mLocalSocket != null) {
            try {
                this.mLocalSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void readFrame(ByteBuffer buffer, int length) {
        this.isTransferEnded = false;
        this.isReadSuccess = false;
        Message msg = new Message();
        msg.what = 1;
        msg.obj = buffer;
        msg.arg1 = length;
        this.mHandler.sendMessage(msg);
    }

    public void interrupt() {
        this.mHandlerThread.interrupt();
    }

    public boolean isConnectFailed() {
        return this.isConnectFailed;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isTransferEnded() {
        return this.isTransferEnded;
    }

    public boolean isReadSuccess() {
        return this.isReadSuccess;
    }

    private void doConnect() {
        for (int count = 0; count < 5; ++count) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mLocalSocket = new LocalSocket();
            try {
                this.mLocalSocket.connect(new LocalSocketAddress(this.mServerAddress));
                InputStream inputStream = this.mLocalSocket.getInputStream();
                this.mReadableByteChannel = Channels.newChannel(inputStream);
                this.isConnected = true;
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        this.isConnectFailed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(ByteBuffer buffer, int length) {
        try {
            int read;
            buffer.rewind();
            for (int count = 0; count < length && (read = this.mReadableByteChannel.read(buffer)) != -1; count += read) {
            }
            this.isReadSuccess = true;
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"read frame exception", (Object[])new Object[0]);
        }
        this.isTransferEnded = true;
        FrameClientThread frameClientThread = this;
        synchronized (frameClientThread) {
            this.notify();
        }
    }

    private class WorkHandler
    extends Handler {
        public WorkHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    FrameClientThread.this.doConnect();
                    break;
                }
                case 1: {
                    ByteBuffer buffer = (ByteBuffer)msg.obj;
                    int length = msg.arg1;
                    FrameClientThread.this.doRead(buffer, length);
                }
            }
        }
    }
}

