/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.frame;

import android.util.SparseArray;
import com.segway.robot.sdk.vision.internal.frame.BaseFrame;
import com.segway.robot.sdk.vision.internal.frame.BaseFrameInfo;
import java.nio.ByteBuffer;
import java.util.Stack;

public class RecyclableFrame
extends BaseFrame {
    static SparseArray<Stack<RecyclableFrame>> mFramePool = new SparseArray();
    ByteBuffer mByteBuffer;
    BaseFrameInfo mBaseFrameInfo;
    private int mBufferSize;

    private RecyclableFrame(int bufferSize, BaseFrameInfo baseFrameInfo) {
        this.mBufferSize = bufferSize;
        this.mBaseFrameInfo = baseFrameInfo;
        this.mByteBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public void reuse(BaseFrameInfo baseFrameInfo) {
        super.reuse();
        this.mBaseFrameInfo = baseFrameInfo;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        this.mByteBuffer.rewind();
        return this.mByteBuffer;
    }

    @Override
    public BaseFrameInfo getInfo() {
        return this.mBaseFrameInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Class<RecyclableFrame> clazz = RecyclableFrame.class;
        synchronized (RecyclableFrame.class) {
            super.release();
            ((Stack)mFramePool.get(this.mBufferSize)).push(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized RecyclableFrame create(int bufferSize, BaseFrameInfo baseFrameInfo) {
        if (mFramePool.get(bufferSize) == null) {
            mFramePool.put(bufferSize, new Stack());
        }
        if (((Stack)mFramePool.get(bufferSize)).empty()) {
            return new RecyclableFrame(bufferSize, baseFrameInfo);
        }
        RecyclableFrame recyclableFrame = (RecyclableFrame)((Stack)mFramePool.get(bufferSize)).pop();
        recyclableFrame.reuse(baseFrameInfo);
        return recyclableFrame;
    }
}

