/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.frame;

import com.segway.robot.sdk.vision.Frame;
import com.segway.robot.sdk.vision.internal.frame.CountableFrame;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import timber.log.Timber;

public class FrameBuffer {
    final int MAX_SIZE = 10;
    List<CountableFrame> mFrameList = new LinkedList<CountableFrame>();

    public synchronized boolean add(CountableFrame frame) {
        Iterator<CountableFrame> iterator = this.mFrameList.iterator();
        while (iterator.hasNext()) {
            CountableFrame f = iterator.next();
            if (f.isLocked()) continue;
            f.release();
            iterator.remove();
        }
        if (this.mFrameList.size() >= 10) {
            Timber.d((String)"Buffer overflow !", (Object[])new Object[0]);
            frame.release();
            return false;
        }
        this.mFrameList.add(frame);
        return true;
    }

    public synchronized Frame getLatest(long previousFrameTid) {
        if (this.mFrameList.size() == 0) {
            return null;
        }
        CountableFrame frame = this.mFrameList.get(this.mFrameList.size() - 1);
        if (frame.getTid() > previousFrameTid) {
            frame.lockCountUp();
            return frame;
        }
        return null;
    }

    public synchronized void returnFrame(Frame frame) {
        ((CountableFrame)frame).lockCountDown();
    }
}

