/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.frame;

import android.os.Parcel;
import android.os.Parcelable;
import java.nio.ByteBuffer;

public class BaseFrameInfo
implements Parcelable {
    public static final int SIZE = 60;
    int streamType;
    int resolution;
    int pixelFormat;
    int intArg0;
    int intArg1;
    int intArg2;
    int intArg3;
    int intArg4;
    int intArg5;
    int intArg6;
    int intArg7;
    long longArg0;
    long longArg1;
    ByteBuffer mByteBuffer;
    public static final Parcelable.Creator<BaseFrameInfo> CREATOR = new Parcelable.Creator<BaseFrameInfo>(){

        public BaseFrameInfo createFromParcel(Parcel in) {
            int streamType = in.readInt();
            int resolution = in.readInt();
            int pixelFormat = in.readInt();
            BaseFrameInfo baseFrameInfo = new BaseFrameInfo(streamType, resolution, pixelFormat);
            baseFrameInfo.intArg0 = in.readInt();
            baseFrameInfo.intArg1 = in.readInt();
            baseFrameInfo.intArg2 = in.readInt();
            baseFrameInfo.intArg3 = in.readInt();
            baseFrameInfo.intArg4 = in.readInt();
            baseFrameInfo.intArg5 = in.readInt();
            baseFrameInfo.intArg6 = in.readInt();
            baseFrameInfo.intArg7 = in.readInt();
            baseFrameInfo.longArg0 = in.readLong();
            baseFrameInfo.longArg1 = in.readLong();
            return baseFrameInfo;
        }

        public BaseFrameInfo[] newArray(int size) {
            return new BaseFrameInfo[size];
        }
    };

    public BaseFrameInfo() {
    }

    public BaseFrameInfo(int streamType, int resolution, int pixelFormat) {
        this.streamType = streamType;
        this.resolution = resolution;
        this.pixelFormat = pixelFormat;
    }

    public BaseFrameInfo(BaseFrameInfo baseFrameInfo) {
        this.streamType = baseFrameInfo.getStreamType();
        this.resolution = baseFrameInfo.getResolution();
        this.pixelFormat = baseFrameInfo.getPixelFormat();
        this.intArg0 = baseFrameInfo.intArg0;
        this.intArg1 = baseFrameInfo.intArg1;
        this.intArg2 = baseFrameInfo.intArg2;
        this.intArg3 = baseFrameInfo.intArg3;
        this.intArg4 = baseFrameInfo.intArg4;
        this.intArg5 = baseFrameInfo.intArg5;
        this.intArg6 = baseFrameInfo.intArg6;
        this.intArg7 = baseFrameInfo.intArg7;
        this.longArg0 = baseFrameInfo.longArg0;
        this.longArg1 = baseFrameInfo.longArg1;
    }

    public void setStreamType(int streamType) {
        this.streamType = streamType;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public int getStreamType() {
        return this.streamType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void setStride(int stride) {
        this.intArg0 = stride;
    }

    public void setFrameNum(int frameNum) {
        this.intArg1 = frameNum;
    }

    public void setExposure(int exposure) {
        this.intArg2 = exposure;
    }

    public void setIMUTimeStamp(long timeStamp) {
        this.longArg0 = timeStamp;
    }

    public long getIMUTimeStamp() {
        return this.longArg0;
    }

    public synchronized ByteBuffer toByteBuffer() {
        if (this.mByteBuffer == null) {
            this.mByteBuffer = ByteBuffer.allocate(60);
        }
        this.mByteBuffer.rewind();
        this.mByteBuffer.putInt(this.streamType);
        this.mByteBuffer.putInt(this.resolution);
        this.mByteBuffer.putInt(this.pixelFormat);
        this.mByteBuffer.putInt(this.intArg0);
        this.mByteBuffer.putInt(this.intArg1);
        this.mByteBuffer.putInt(this.intArg2);
        this.mByteBuffer.putInt(this.intArg3);
        this.mByteBuffer.putInt(this.intArg4);
        this.mByteBuffer.putInt(this.intArg5);
        this.mByteBuffer.putInt(this.intArg6);
        this.mByteBuffer.putInt(this.intArg7);
        this.mByteBuffer.putLong(this.longArg0);
        this.mByteBuffer.putLong(this.longArg1);
        this.mByteBuffer.rewind();
        return this.mByteBuffer;
    }

    public static BaseFrameInfo fromByteBuffer(ByteBuffer buffer) {
        BaseFrameInfo baseFrameInfo = new BaseFrameInfo();
        buffer.rewind();
        baseFrameInfo.streamType = buffer.getInt();
        baseFrameInfo.resolution = buffer.getInt();
        baseFrameInfo.pixelFormat = buffer.getInt();
        baseFrameInfo.intArg0 = buffer.getInt();
        baseFrameInfo.intArg1 = buffer.getInt();
        baseFrameInfo.intArg2 = buffer.getInt();
        baseFrameInfo.intArg3 = buffer.getInt();
        baseFrameInfo.intArg4 = buffer.getInt();
        baseFrameInfo.intArg5 = buffer.getInt();
        baseFrameInfo.intArg6 = buffer.getInt();
        baseFrameInfo.intArg7 = buffer.getInt();
        baseFrameInfo.longArg0 = buffer.getLong();
        baseFrameInfo.longArg1 = buffer.getLong();
        return baseFrameInfo;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.streamType);
        dest.writeInt(this.resolution);
        dest.writeInt(this.pixelFormat);
        dest.writeInt(this.intArg0);
        dest.writeInt(this.intArg1);
        dest.writeInt(this.intArg2);
        dest.writeInt(this.intArg3);
        dest.writeInt(this.intArg4);
        dest.writeInt(this.intArg5);
        dest.writeInt(this.intArg6);
        dest.writeInt(this.intArg7);
        dest.writeLong(this.longArg0);
        dest.writeLong(this.longArg1);
    }
}

