/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.imu;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class IMUFrame {
    private ByteBuffer mBuffer;

    public IMUFrame(ByteBuffer buffer) {
        this.mBuffer = buffer;
        this.mBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public IMUFrame(byte[] array) {
        this.mBuffer = ByteBuffer.wrap(array);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public long getTimeStamp() {
        return this.mBuffer.getLong(0);
    }

    public long getSequence() {
        return this.mBuffer.getLong(8);
    }

    public int getType() {
        return this.mBuffer.getInt(16);
    }

    public float getX() {
        return this.mBuffer.getFloat(24);
    }

    public float getY() {
        return this.mBuffer.getFloat(28);
    }

    public float getZ() {
        return this.mBuffer.getFloat(32);
    }
}

