/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.SparseArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.base.version.VersionMismatchException;
import com.segway.robot.sdk.vision.AprSenseStateCallback;
import com.segway.robot.sdk.vision.Frame;
import com.segway.robot.sdk.vision.IAprSenseService;
import com.segway.robot.sdk.vision.IAprSenseServiceCallback;
import com.segway.robot.sdk.vision.ImageStreamCallback;
import com.segway.robot.sdk.vision.VisionServiceCallback;
import com.segway.robot.sdk.vision.VisionServiceException;
import com.segway.robot.sdk.vision.imu.IIMUDataCallback;
import com.segway.robot.sdk.vision.imu.IMUCallbackBundle;
import com.segway.robot.sdk.vision.imu.IMUDataCallback;
import com.segway.robot.sdk.vision.internal.frame.BaseFrameInfo;
import com.segway.robot.sdk.vision.internal.frame.DepthFrameInfo;
import com.segway.robot.sdk.vision.internal.frame.FishEyeFrameInfo;
import com.segway.robot.sdk.vision.internal.frame.FrameBuffer;
import com.segway.robot.sdk.vision.internal.socket.FrameClientThread;
import com.segway.robot.sdk.vision.internal.socket.ImageReaderThreadManager;
import com.segway.robot.sdk.vision.person.FindPersonsHandler;
import com.segway.robot.sdk.vision.person.Person;
import com.segway.robot.sdk.vision.person.PersonDetectCallback;
import com.segway.robot.sdk.vision.stream.FrameRate;
import com.segway.robot.sdk.vision.stream.PixelFormat;
import com.segway.robot.sdk.vision.stream.Resolution;
import com.segway.robot.sdk.vision.stream.StreamProfile;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import timber.log.Timber;

public class VisionServiceManager {
    private static final String SERVICE_PACKAGE_NAME = "com.segway.robot.host.coreservice.vision";
    private static final String SERVICE_CLASS_NAME = "com.segway.robot.host.coreservice.vision.AprSenseService";
    private static final int SURFACE_HOLDER_CALLBACK_TAG_KEY = 701157500;
    private static final int SURFACE_HOLDER_PROFILE_TAG_KEY = 701157501;
    private static final int IMU_DATA_SIZE = 800;
    private static VisionServiceManager mInstance;
    private static Context mContext;
    private Object mDummy = new Object();
    private IAprSenseService mAprSenseAIDLService;
    private List<VisionServiceCallback> mVisionServiceCallbacks = new ArrayList<VisionServiceCallback>();
    private List<AprSenseStateCallback> mAprSenseStateCallback = new ArrayList<AprSenseStateCallback>();
    private List<PersonDetectCallback> mPersonDetectCallback = new ArrayList<PersonDetectCallback>();
    private List<IMUCallbackBundle> mIMUDataCallbacks = new ArrayList<IMUCallbackBundle>();
    private SparseArray<Object> mImageCallbackMap = new SparseArray();
    private SparseArray<FrameBuffer> mFrameBufferMap = new SparseArray();
    private SparseArray<FrameClientThread> mFrameTransferMap = new SparseArray();
    private SparseArray<SharedMemoryHolder> mFrameTransferSharedMemoryMap = new SparseArray();
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            VisionServiceManager.this.mAprSenseAIDLService = IAprSenseService.Stub.asInterface(service);
            try {
                VisionServiceManager.this.mAprSenseAIDLService.addCallback(VisionServiceManager.this.mAprSenseServiceCallback);
                VisionServiceManager.this.mAprSenseAIDLService.addFindPersonHandler(VisionServiceManager.this.mFindPersonHandler);
            }
            catch (RemoteException e) {
                VisionServiceManager.this.notifyRealSenseError(1, "Cannot add the internal AprSense callback.");
                mContext.unbindService((ServiceConnection)this);
                Timber.e((String)"Connected to AprSenseService but cannot add the internal callback.", (Object[])new Object[]{e});
                return;
            }
            try {
                Version serviceVersion = VisionServiceManager.this.mAprSenseAIDLService.getVersion();
                VisionServiceManager.this.getVersion().check("VersionInfo", serviceVersion);
            }
            catch (RemoteException serviceVersion) {
            }
            catch (VersionMismatchException e) {
                Timber.e((Throwable)e, (String)"Version mismatch", (Object[])new Object[0]);
            }
            VisionServiceManager.this.notifyServiceConnected();
            Timber.d((String)"AprSenseService connected.", (Object[])new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            int i;
            VisionServiceManager.this.mAprSenseAIDLService = null;
            VisionServiceManager.this.notifyServiceDisconnected();
            mContext = null;
            SparseArray sparseArray = VisionServiceManager.this.mFrameTransferMap;
            synchronized (sparseArray) {
                for (i = 0; i < VisionServiceManager.this.mFrameTransferMap.size(); ++i) {
                    FrameClientThread frameClientThread = (FrameClientThread)VisionServiceManager.this.mFrameTransferMap.valueAt(i);
                    frameClientThread.disconnect();
                }
                VisionServiceManager.this.mFrameTransferMap.clear();
            }
            sparseArray = VisionServiceManager.this.mFrameTransferSharedMemoryMap;
            synchronized (sparseArray) {
                for (i = 0; i < VisionServiceManager.this.mFrameTransferSharedMemoryMap.size(); ++i) {
                    SharedMemoryHolder sharedMemoryHolder = (SharedMemoryHolder)VisionServiceManager.this.mFrameTransferSharedMemoryMap.valueAt(i);
                    sharedMemoryHolder.parcelFileDescriptor = null;
                    try {
                        sharedMemoryHolder.inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    sharedMemoryHolder.inputStream = null;
                }
                VisionServiceManager.this.mFrameTransferSharedMemoryMap.clear();
            }
            sparseArray = VisionServiceManager.this.mImageCallbackMap;
            synchronized (sparseArray) {
                VisionServiceManager.this.mImageCallbackMap.clear();
            }
            Timber.d((String)"AprSenseService disconnected.", (Object[])new Object[0]);
        }
    };
    IAprSenseServiceCallback.Stub mAprSenseServiceCallback = new IAprSenseServiceCallback.Stub(){

        @Override
        public void onAprStateChanged(int state, int errorCode, String errorMessage) throws RemoteException {
            switch (state) {
                case 1: {
                    VisionServiceManager.this.notifyAprSenseStarted();
                    break;
                }
                case 2: {
                    VisionServiceManager.this.notifyRealSenseStopped();
                    break;
                }
                case 3: {
                    VisionServiceManager.this.notifyRealSenseError(errorCode, errorMessage);
                }
            }
        }
    };
    FindPersonsHandler.Stub mFindPersonHandler = new FindPersonsHandler.Stub(){

        @Override
        public void onFindPersons(List<Person> persons) throws RemoteException {
            for (PersonDetectCallback personDetectCallback : VisionServiceManager.this.mPersonDetectCallback) {
                personDetectCallback.onPersonDetected(persons);
            }
        }
    };
    IIMUDataCallback.Stub mIImuDataCallback = new IIMUDataCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewData(byte[] buff, int length, int frameCount) throws RemoteException {
            List list = VisionServiceManager.this.mIMUDataCallbacks;
            synchronized (list) {
                for (IMUCallbackBundle bundle : VisionServiceManager.this.mIMUDataCallbacks) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buff);
                    ReadableByteChannel readableByteChannel = Channels.newChannel(byteArrayInputStream);
                    bundle.buffer.rewind();
                    try {
                        readableByteChannel.read(bundle.buffer);
                    }
                    catch (IOException e) {
                        Timber.e((Throwable)e, (String)"An error occurs in copying the IMU data.", (Object[])new Object[0]);
                    }
                    bundle.callback.onNewData(bundle.buffer, length, frameCount);
                }
            }
        }
    };

    public static synchronized VisionServiceManager getInstance() {
        if (mInstance == null) {
            mInstance = new VisionServiceManager();
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisionServiceCallback(VisionServiceCallback visionServiceCallback) {
        if (visionServiceCallback == null) {
            return;
        }
        List<VisionServiceCallback> list = this.mVisionServiceCallbacks;
        synchronized (list) {
            if (!this.mVisionServiceCallbacks.contains(visionServiceCallback)) {
                this.mVisionServiceCallbacks.add(visionServiceCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisionServiceCallback(VisionServiceCallback visionServiceCallback) {
        if (visionServiceCallback == null) {
            return;
        }
        List<VisionServiceCallback> list = this.mVisionServiceCallbacks;
        synchronized (list) {
            this.mVisionServiceCallbacks.remove(visionServiceCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRealSenseStateCallback(AprSenseStateCallback aprSenseStateCallback) {
        if (aprSenseStateCallback == null) {
            return;
        }
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            if (!this.mAprSenseStateCallback.contains(aprSenseStateCallback)) {
                this.mAprSenseStateCallback.add(aprSenseStateCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRealSenseStateCallback(AprSenseStateCallback aprSenseStateCallback) {
        if (aprSenseStateCallback == null) {
            return;
        }
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            this.mAprSenseStateCallback.remove(aprSenseStateCallback);
        }
    }

    public synchronized boolean connectService(Context context, VisionServiceCallback visionServiceCallback) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null!");
        }
        if (mContext != null) {
            throw new VisionServiceException("The service is already connected.");
        }
        mContext = context.getApplicationContext();
        this.addVisionServiceCallback(visionServiceCallback);
        Intent startServiceIntent = new Intent();
        startServiceIntent.setClassName(SERVICE_PACKAGE_NAME, SERVICE_CLASS_NAME);
        startServiceIntent.putExtra("PackageNameFPC", context.getPackageName());
        return mContext.bindService(startServiceIntent, this.mServiceConnection, 1);
    }

    public synchronized void disconnectService() {
        if (mContext != null) {
            mContext.unbindService(this.mServiceConnection);
            mContext = null;
        }
    }

    public synchronized boolean isServiceConnected() {
        return mContext != null;
    }

    public synchronized void startAprSense(AprSenseStateCallback aprSenseStateCallback) {
        this.checkConnected();
        try {
            if (this.mAprSenseAIDLService.isAprSenseRunning()) {
                throw new VisionServiceException("AprSense is already started.");
            }
            this.mAprSenseAIDLService.startAprSense();
            this.addRealSenseStateCallback(aprSenseStateCallback);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public synchronized void stopAprSense() {
        this.checkConnected();
        try {
            if (!this.mAprSenseAIDLService.isAprSenseRunning()) {
                throw new VisionServiceException("AprSense is not running");
            }
            this.mAprSenseAIDLService.stopAprSense();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public boolean isAprSenseRunning() {
        this.checkConnected();
        try {
            return this.mAprSenseAIDLService.isAprSenseRunning();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void enableStream(int streamType, @Resolution.VisionResolution int resolution, @FrameRate.VisionFrameRate int fps, @PixelFormat.VisionPixelFormat int pixelFormat) throws VisionServiceException {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.enableStream(streamType, resolution, fps, pixelFormat);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void enableStream(StreamProfile streamProfile) {
        this.checkConnected();
        int resolution = Resolution.toVisionServiceResolution(streamProfile.getWidth(), streamProfile.getHeight());
        if (resolution == 0) {
            throw new VisionServiceException("The width or height is not supported.");
        }
        try {
            this.mAprSenseAIDLService.enableStream(streamProfile.getStreamType(), resolution, streamProfile.getFps(), streamProfile.getPixelFormat());
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void cleanStreams() throws VisionServiceException {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.cleanStreams();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public StreamProfile[] getActivatedStreamProfiles() throws VisionServiceException {
        this.checkConnected();
        try {
            return this.mAprSenseAIDLService.getActivatedStreamProfile();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void startPreview(final SurfaceView surfaceView, final StreamProfile streamProfile, final boolean showPerson) throws VisionServiceException {
        this.checkConnected();
        this.checkAprSenseStarted();
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        surfaceHolder.setFixedSize(streamProfile.getWidth(), streamProfile.getHeight());
        SurfaceHolder.Callback callback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                Timber.i((String)"Surface %d. surfaceCreated", (Object[])new Object[]{surfaceView.getId()});
                try {
                    VisionServiceManager.this.preview(streamProfile.getStreamType(), holder.getSurface(), showPerson);
                }
                catch (VisionServiceException e) {
                    VisionServiceManager.this.notifyRealSenseError(4, e.getMessage());
                }
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                Timber.i((String)"Surface %d. surfaceChanged format = %d width = %d height = %d", (Object[])new Object[]{surfaceView.getId(), format, width, height});
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                Timber.i((String)"Surface %d. surfaceDestroyed", (Object[])new Object[]{surfaceView.getId()});
            }
        };
        surfaceView.setTag(701157500, (Object)callback);
        surfaceView.setTag(701157501, (Object)streamProfile);
        surfaceHolder.addCallback(callback);
    }

    public void stopPreview(SurfaceView surfaceView) {
        this.checkConnected();
        this.checkAprSenseStarted();
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        SurfaceHolder.Callback callback = (SurfaceHolder.Callback)surfaceView.getTag(701157500);
        StreamProfile streamProfile = (StreamProfile)surfaceView.getTag(701157501);
        if (callback != null) {
            surfaceHolder.removeCallback(callback);
        }
        try {
            this.mAprSenseAIDLService.stopPreview(streamProfile.getStreamType());
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startImageStream(StreamProfile streamProfile, ImageStreamCallback callback) {
        this.checkConnected();
        if (streamProfile == null) {
            throw new IllegalArgumentException("The stream profile cannot be null.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("The image stream callback cannot be null.");
        }
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamProfile.getStreamType()) != null) {
                throw new VisionServiceException("The stream is duplicated.");
            }
            this.mImageCallbackMap.put(streamProfile.getStreamType(), this.mDummy);
        }
        try {
            String address = this.mAprSenseAIDLService.setupImageTransferSocket(streamProfile.getStreamType(), 1);
            ImageReaderThreadManager.getInstance().addConnection(streamProfile, address, callback);
        }
        catch (Exception e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startImageStreamToBuffer(StreamProfile streamProfile) {
        FrameBuffer frameBuffer;
        this.checkConnected();
        if (streamProfile == null) {
            throw new IllegalArgumentException("stream profile can't be null");
        }
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamProfile.getStreamType()) != null) {
                throw new VisionServiceException("stream duplicated");
            }
            this.mImageCallbackMap.put(streamProfile.getStreamType(), this.mDummy);
        }
        SparseArray<FrameBuffer> sparseArray2 = this.mFrameBufferMap;
        synchronized (sparseArray2) {
            if (this.mFrameBufferMap.get(streamProfile.getStreamType()) == null) {
                this.mFrameBufferMap.put(streamProfile.getStreamType(), (Object)new FrameBuffer());
            }
            frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamProfile.getStreamType());
        }
        try {
            String address = this.mAprSenseAIDLService.setupImageTransferSocket(streamProfile.getStreamType(), 1);
            ImageReaderThreadManager.getInstance().addConnection(streamProfile, address, frameBuffer);
        }
        catch (Exception e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopImageStream(StreamProfile streamProfile) {
        this.checkConnected();
        this.checkAprSenseStarted();
        SparseArray<Object> sparseArray = this.mImageCallbackMap;
        synchronized (sparseArray) {
            if (this.mImageCallbackMap.get(streamProfile.getStreamType()) == null) {
                throw new VisionServiceException("The stream is not started " + streamProfile.getStreamType());
            }
            this.mImageCallbackMap.remove(streamProfile.getStreamType());
        }
        sparseArray = this.mFrameBufferMap;
        synchronized (sparseArray) {
            this.mFrameBufferMap.delete(streamProfile.getStreamType());
        }
        try {
            ImageReaderThreadManager.getInstance().removeConnection(streamProfile);
            this.mAprSenseAIDLService.stopImageTransfer(streamProfile.getStreamType(), 1);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame getLatestFrameForStream(StreamProfile streamProfile, long previousTid) {
        FrameBuffer frameBuffer;
        if (streamProfile == null) {
            throw new IllegalArgumentException("stream profile can't be null");
        }
        SparseArray<FrameBuffer> sparseArray = this.mFrameBufferMap;
        synchronized (sparseArray) {
            frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamProfile.getStreamType());
        }
        if (frameBuffer == null) {
            throw new IllegalArgumentException("stream image transfer not initialized");
        }
        return frameBuffer.getLatest(previousTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnFrameToStream(StreamProfile streamProfile, Frame frame) {
        FrameBuffer frameBuffer;
        if (streamProfile == null) {
            throw new IllegalArgumentException("stream profile can't be null");
        }
        if (frame == null) {
            throw new IllegalArgumentException("can not return null frame");
        }
        SparseArray<FrameBuffer> sparseArray = this.mFrameBufferMap;
        synchronized (sparseArray) {
            frameBuffer = (FrameBuffer)this.mFrameBufferMap.get(streamProfile.getStreamType());
        }
        if (frameBuffer == null) {
            throw new IllegalArgumentException("stream image transfer not initialized");
        }
        frameBuffer.returnFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFrameTransfer(StreamProfile profile) {
        String address;
        this.checkConnected();
        SparseArray<FrameClientThread> sparseArray = this.mFrameTransferMap;
        synchronized (sparseArray) {
            if (this.mFrameTransferMap.get(profile.getStreamType()) != null) {
                throw new VisionServiceException("The frame profile is duplicated.");
            }
        }
        try {
            address = this.mAprSenseAIDLService.setupImageTransferSocket(profile.getStreamType(), 2);
        }
        catch (RemoteException e) {
            throw new VisionServiceException("An error occurs in seting up the image transfer socket.", e);
        }
        FrameClientThread frameClientThread = new FrameClientThread(profile);
        frameClientThread.connectServer(address);
        SparseArray<FrameClientThread> sparseArray2 = this.mFrameTransferMap;
        synchronized (sparseArray2) {
            this.mFrameTransferMap.put(profile.getStreamType(), (Object)frameClientThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFrameTransfer(StreamProfile profile) {
        this.checkConnected();
        SparseArray<FrameClientThread> sparseArray = this.mFrameTransferMap;
        synchronized (sparseArray) {
            FrameClientThread frameClientThread = (FrameClientThread)this.mFrameTransferMap.get(profile.getStreamType());
            if (frameClientThread != null) {
                frameClientThread.disconnect();
                this.mFrameTransferMap.remove(profile.getStreamType());
            }
        }
        try {
            this.mAprSenseAIDLService.stopImageTransfer(profile.getStreamType(), 2);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableFrameTransferMemoryFile(StreamProfile profile) {
        this.checkConnected();
        SparseArray<SharedMemoryHolder> sparseArray = this.mFrameTransferSharedMemoryMap;
        synchronized (sparseArray) {
            if (this.mFrameTransferSharedMemoryMap.get(profile.getStreamType()) != null) {
                throw new VisionServiceException("frame profile duplicated");
            }
        }
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.mAprSenseAIDLService.setupImageTransferSharedMemory(profile.getStreamType(), 2);
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            SharedMemoryHolder sharedMemoryHolder = new SharedMemoryHolder();
            sharedMemoryHolder.parcelFileDescriptor = parcelFileDescriptor;
            sharedMemoryHolder.inputStream = fileInputStream;
            SparseArray<SharedMemoryHolder> sparseArray2 = this.mFrameTransferSharedMemoryMap;
            synchronized (sparseArray2) {
                this.mFrameTransferSharedMemoryMap.put(profile.getStreamType(), (Object)sharedMemoryHolder);
            }
        }
        catch (RemoteException e) {
            throw new VisionServiceException("setup image transfer socket error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFrameTransferMemoryFile(StreamProfile profile) {
        this.checkConnected();
        SparseArray<SharedMemoryHolder> sparseArray = this.mFrameTransferSharedMemoryMap;
        synchronized (sparseArray) {
            SharedMemoryHolder sharedMemoryHolder = (SharedMemoryHolder)this.mFrameTransferSharedMemoryMap.get(profile.getStreamType());
            if (sharedMemoryHolder != null) {
                sharedMemoryHolder.parcelFileDescriptor = null;
                try {
                    sharedMemoryHolder.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                sharedMemoryHolder.inputStream = null;
                this.mFrameTransferSharedMemoryMap.remove(profile.getStreamType());
            }
        }
        try {
            this.mAprSenseAIDLService.stopImageTransfer(profile.getStreamType(), 2);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public FishEyeFrameInfo getFishEyeFrame(StreamProfile streamProfile, ByteBuffer buffer) {
        this.checkConnected();
        this.checkAprSenseStarted();
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        BaseFrameInfo baseFrameInfo = this.getFrame(streamProfile, buffer);
        if (baseFrameInfo != null) {
            return new FishEyeFrameInfo(baseFrameInfo);
        }
        return null;
    }

    public DepthFrameInfo getDepthFrame(StreamProfile streamProfile, ByteBuffer buffer) {
        this.checkConnected();
        this.checkAprSenseStarted();
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        BaseFrameInfo baseFrameInfo = this.getFrame(streamProfile, buffer);
        if (baseFrameInfo != null) {
            return new DepthFrameInfo(baseFrameInfo);
        }
        return null;
    }

    @Deprecated
    public BaseFrameInfo getColorFrame(StreamProfile streamProfile, ByteBuffer buffer) {
        this.checkConnected();
        this.checkAprSenseStarted();
        if (buffer == null) {
            throw new IllegalArgumentException("The buffer is null.");
        }
        return this.getFrame(streamProfile, buffer);
    }

    public BaseFrameInfo getFrameSharedMemory(StreamProfile profile, ByteBuffer buffer) {
        SharedMemoryHolder sharedMemoryHolder = (SharedMemoryHolder)this.mFrameTransferSharedMemoryMap.get(profile.getStreamType());
        if (sharedMemoryHolder == null) {
            throw new VisionServiceException("stream " + profile.getStreamType() + " not enabled");
        }
        try {
            BaseFrameInfo baseFrameInfo = this.mAprSenseAIDLService.getFrameMemoryFile(profile.getStreamType(), profile.getResolution(), profile.getPixelFormat());
            if (baseFrameInfo == null) {
                return null;
            }
            try {
                buffer.rewind();
                FileInputStream inputStream = sharedMemoryHolder.inputStream;
                int n = inputStream.getChannel().position(0L).read(buffer);
            }
            catch (IOException e) {
                throw new VisionServiceException(e);
            }
            return baseFrameInfo;
        }
        catch (RemoteException e) {
            throw new VisionServiceException("get Frame failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFrameInfo getFrame(StreamProfile profile, ByteBuffer buffer) {
        BaseFrameInfo baseFrameInfo;
        FrameClientThread frameClientThread;
        SparseArray<FrameClientThread> sparseArray = this.mFrameTransferMap;
        synchronized (sparseArray) {
            frameClientThread = (FrameClientThread)this.mFrameTransferMap.get(profile.getStreamType());
        }
        if (frameClientThread == null) {
            throw new VisionServiceException("frame transfer for stream " + profile.getStreamType() + " not started");
        }
        try {
            baseFrameInfo = this.mAprSenseAIDLService.getFrame(profile.getStreamType(), profile.getResolution(), profile.getPixelFormat());
        }
        catch (RemoteException e) {
            throw new VisionServiceException("get Frame failed", e);
        }
        if (baseFrameInfo == null) {
            return null;
        }
        int length = (int)(PixelFormat.getPixelBytes(profile.getPixelFormat()) * (float)profile.getHeight() * (float)profile.getWidth());
        frameClientThread.readFrame(buffer, length);
        FrameClientThread frameClientThread2 = frameClientThread;
        synchronized (frameClientThread2) {
            while (!frameClientThread.isTransferEnded()) {
                try {
                    frameClientThread.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!frameClientThread.isReadSuccess()) {
            Timber.e((String)"read frame not success, check log for details", (Object[])new Object[0]);
            throw new VisionServiceException("read frame failed");
        }
        return baseFrameInfo;
    }

    public void startPersonDetection(PersonDetectCallback callback) {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.startPersonDetection();
            if (callback != null) {
                this.mPersonDetectCallback.add(callback);
            }
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void stopPersonDetection() {
        this.checkConnected();
        this.checkAprSenseStarted();
        this.mPersonDetectCallback.clear();
        try {
            this.mAprSenseAIDLService.stopPersonDetection();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void startPersonTracking(int personId) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.startPersonTracking(personId);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void stopPersonTracking(int personId) {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            this.mAprSenseAIDLService.stopPersonTracking(personId);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public List<Person> findPersons() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.findPersons();
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void loadPersonDatabase(String databasePath) {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.loadRecognitionDatabase(databasePath);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public void savePersonDatabase(String databasePath) {
        this.checkConnected();
        try {
            this.mAprSenseAIDLService.saveRecognitionDatabase(databasePath);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    public long getAprSenseTimeStamp() {
        this.checkConnected();
        this.checkAprSenseStarted();
        try {
            return this.mAprSenseAIDLService.getAprSenseTimeStamp();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("An exception occurs in getting the AprSense timestamp! ", e);
        }
    }

    public float getDepthFocalLengthX() {
        try {
            return this.mAprSenseAIDLService.getFloatParam(501);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    public float getDepthFocalLengthY() {
        try {
            return this.mAprSenseAIDLService.getFloatParam(502);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    public float getDepthPrincipalPointX() {
        try {
            return this.mAprSenseAIDLService.getFloatParam(503);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    public float getDepthPrincipalPointY() {
        try {
            return this.mAprSenseAIDLService.getFloatParam(504);
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIMUDataCallback(IMUDataCallback callback) {
        this.checkConnected();
        List<IMUCallbackBundle> list = this.mIMUDataCallbacks;
        synchronized (list) {
            for (IMUCallbackBundle bundle : this.mIMUDataCallbacks) {
                if (bundle.callback != callback) continue;
                return;
            }
            IMUCallbackBundle bundle = new IMUCallbackBundle();
            bundle.callback = callback;
            bundle.buffer = ByteBuffer.allocateDirect(800);
            this.mIMUDataCallbacks.add(bundle);
            if (this.mIMUDataCallbacks.size() == 1) {
                try {
                    this.mAprSenseAIDLService.setIMUDataCallback(this.mIImuDataCallback);
                }
                catch (RemoteException e) {
                    throw new VisionServiceException("add IMU Data Callback exception! ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIMUDataCallback(IMUDataCallback callback) {
        this.checkConnected();
        List<IMUCallbackBundle> list = this.mIMUDataCallbacks;
        synchronized (list) {
            IMUCallbackBundle removeBundle = null;
            for (IMUCallbackBundle bundle : this.mIMUDataCallbacks) {
                this.mIMUDataCallbacks.remove(callback);
                if (bundle.callback != callback) continue;
                removeBundle = bundle;
                break;
            }
            if (removeBundle != null) {
                this.mIMUDataCallbacks.remove(removeBundle);
            }
            if (this.mIMUDataCallbacks.size() == 0) {
                try {
                    this.mAprSenseAIDLService.removeIMUDataCallback();
                }
                catch (RemoteException e) {
                    throw new VisionServiceException("An exception occurs in removing the IMU Data callback! ", e);
                }
            }
        }
    }

    public byte[] getCalibrationData() {
        this.checkConnected();
        try {
            return this.mAprSenseAIDLService.getCalibrationData();
        }
        catch (RemoteException e) {
            throw new VisionServiceException("Get calibration data failed");
        }
    }

    private void checkConnected() throws VisionServiceException {
        if (this.mAprSenseAIDLService == null) {
            throw VisionServiceException.getServiceNotConnectedException();
        }
    }

    private void checkAprSenseStarted() throws VisionServiceException {
        try {
            boolean started = this.mAprSenseAIDLService.isAprSenseRunning();
            if (!started) {
                throw VisionServiceException.getAprSenseNotStaredException();
            }
        }
        catch (RemoteException e) {
            throw new VisionServiceException(e);
        }
    }

    private void preview(int streamType, Surface surface, boolean drawPerson) throws VisionServiceException {
        try {
            this.mAprSenseAIDLService.startPreview(streamType, surface, drawPerson);
        }
        catch (RemoteException e) {
            throw VisionServiceException.toVisionServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyServiceConnected() {
        List<VisionServiceCallback> list = this.mVisionServiceCallbacks;
        synchronized (list) {
            for (VisionServiceCallback visionServiceCallback : this.mVisionServiceCallbacks) {
                visionServiceCallback.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyServiceDisconnected() {
        List<VisionServiceCallback> list = this.mVisionServiceCallbacks;
        synchronized (list) {
            for (VisionServiceCallback visionServiceCallback : this.mVisionServiceCallbacks) {
                visionServiceCallback.onServiceDisconnected();
            }
            this.mVisionServiceCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAprSenseStarted() {
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            for (AprSenseStateCallback aprSenseStateCallback : this.mAprSenseStateCallback) {
                aprSenseStateCallback.onAprSenseStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRealSenseStopped() {
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            for (AprSenseStateCallback aprSenseStateCallback : this.mAprSenseStateCallback) {
                aprSenseStateCallback.onAprSenseStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRealSenseError(int errorCode, String errorMsg) {
        List<AprSenseStateCallback> list = this.mAprSenseStateCallback;
        synchronized (list) {
            for (AprSenseStateCallback aprSenseStateCallback : this.mAprSenseStateCallback) {
                aprSenseStateCallback.onAprSenseError(errorCode, errorMsg);
            }
        }
    }

    public Version getVersion() {
        return new Version("EXPERIMENT", "privatebuild.dev2.1372c4b", 102, 100);
    }

    private class SharedMemoryHolder {
        ParcelFileDescriptor parcelFileDescriptor;
        FileInputStream inputStream;

        private SharedMemoryHolder() {
        }
    }
}

