/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.Surface;
import com.segway.robot.sdk.base.version.Version;
import com.segway.robot.sdk.vision.IAprSenseServiceCallback;
import com.segway.robot.sdk.vision.imu.IIMUDataCallback;
import com.segway.robot.sdk.vision.internal.frame.BaseFrameInfo;
import com.segway.robot.sdk.vision.person.FindPersonsHandler;
import com.segway.robot.sdk.vision.person.Person;
import com.segway.robot.sdk.vision.stream.StreamProfile;
import java.util.ArrayList;
import java.util.List;

public interface IAprSenseService
extends IInterface {
    public void startAprSense() throws RemoteException;

    public void stopAprSense() throws RemoteException;

    public boolean isAprSenseRunning() throws RemoteException;

    public void addCallback(IAprSenseServiceCallback var1) throws RemoteException;

    public void enableStream(int var1, int var2, int var3, int var4) throws RemoteException;

    public void cleanStreams() throws RemoteException;

    public StreamProfile[] getActivatedStreamProfile() throws RemoteException;

    public void startPreview(int var1, Surface var2, boolean var3) throws RemoteException;

    public void stopPreview(int var1) throws RemoteException;

    public String setupImageTransferSocket(int var1, int var2) throws RemoteException;

    public void stopImageTransfer(int var1, int var2) throws RemoteException;

    public void addFindPersonHandler(FindPersonsHandler var1) throws RemoteException;

    public void startPersonDetection() throws RemoteException;

    public void stopPersonDetection() throws RemoteException;

    public void startPersonTracking(int var1) throws RemoteException;

    public void stopPersonTracking(int var1) throws RemoteException;

    public List<Person> findPersons() throws RemoteException;

    public void loadRecognitionDatabase(String var1) throws RemoteException;

    public void saveRecognitionDatabase(String var1) throws RemoteException;

    public long getAprSenseTimeStamp() throws RemoteException;

    public void setIMUDataCallback(IIMUDataCallback var1) throws RemoteException;

    public void removeIMUDataCallback() throws RemoteException;

    public BaseFrameInfo getFrame(int var1, int var2, int var3) throws RemoteException;

    public BaseFrameInfo getFrameMemoryFile(int var1, int var2, int var3) throws RemoteException;

    public ParcelFileDescriptor setupImageTransferSharedMemory(int var1, int var2) throws RemoteException;

    public float getFloatParam(int var1) throws RemoteException;

    public byte[] getCalibrationData() throws RemoteException;

    public Version getVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAprSenseService {
        private static final String DESCRIPTOR = "com.segway.robot.sdk.vision.IAprSenseService";
        static final int TRANSACTION_startAprSense = 1;
        static final int TRANSACTION_stopAprSense = 2;
        static final int TRANSACTION_isAprSenseRunning = 3;
        static final int TRANSACTION_addCallback = 4;
        static final int TRANSACTION_enableStream = 5;
        static final int TRANSACTION_cleanStreams = 6;
        static final int TRANSACTION_getActivatedStreamProfile = 7;
        static final int TRANSACTION_startPreview = 8;
        static final int TRANSACTION_stopPreview = 9;
        static final int TRANSACTION_setupImageTransferSocket = 10;
        static final int TRANSACTION_stopImageTransfer = 11;
        static final int TRANSACTION_addFindPersonHandler = 12;
        static final int TRANSACTION_startPersonDetection = 13;
        static final int TRANSACTION_stopPersonDetection = 14;
        static final int TRANSACTION_startPersonTracking = 15;
        static final int TRANSACTION_stopPersonTracking = 16;
        static final int TRANSACTION_findPersons = 17;
        static final int TRANSACTION_loadRecognitionDatabase = 18;
        static final int TRANSACTION_saveRecognitionDatabase = 19;
        static final int TRANSACTION_getAprSenseTimeStamp = 20;
        static final int TRANSACTION_setIMUDataCallback = 21;
        static final int TRANSACTION_removeIMUDataCallback = 22;
        static final int TRANSACTION_getFrame = 23;
        static final int TRANSACTION_getFrameMemoryFile = 24;
        static final int TRANSACTION_setupImageTransferSharedMemory = 25;
        static final int TRANSACTION_getFloatParam = 26;
        static final int TRANSACTION_getCalibrationData = 27;
        static final int TRANSACTION_getVersion = 28;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAprSenseService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAprSenseService) {
                return (IAprSenseService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    this.startAprSense();
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopAprSense();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isAprSenseRunning();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    IAprSenseServiceCallback _arg0 = IAprSenseServiceCallback.Stub.asInterface(data.readStrongBinder());
                    this.addCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.enableStream(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    this.cleanStreams();
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    Parcelable[] _result = this.getActivatedStreamProfile();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    Surface _arg1 = 0 != data.readInt() ? (Surface)Surface.CREATOR.createFromParcel(data) : null;
                    boolean _arg2 = 0 != data.readInt();
                    this.startPreview(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.stopPreview(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _result = this.setupImageTransferSocket(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.stopImageTransfer(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    FindPersonsHandler _arg0 = FindPersonsHandler.Stub.asInterface(data.readStrongBinder());
                    this.addFindPersonHandler(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    this.startPersonDetection();
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    this.stopPersonDetection();
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.startPersonTracking(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.stopPersonTracking(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    List _result = this.findPersons();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.loadRecognitionDatabase(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.saveRecognitionDatabase(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    long _result = this.getAprSenseTimeStamp();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    IIMUDataCallback _arg0 = IIMUDataCallback.Stub.asInterface(data.readStrongBinder());
                    this.setIMUDataCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    this.removeIMUDataCallback();
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    BaseFrameInfo _result = this.getFrame(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    BaseFrameInfo _result = this.getFrameMemoryFile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ParcelFileDescriptor _result = this.setupImageTransferSharedMemory(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    float _result = this.getFloatParam(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    byte[] _result = this.getCalibrationData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    Version _result = this.getVersion();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IAprSenseService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void startAprSense() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopAprSense() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAprSenseRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCallback(IAprSenseServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableStream(int streamType, int resolution, int fps, int pixerformat) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(resolution);
                    _data.writeInt(fps);
                    _data.writeInt(pixerformat);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void cleanStreams() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StreamProfile[] getActivatedStreamProfile() throws RemoteException {
                StreamProfile[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = (StreamProfile[])_reply.createTypedArray(StreamProfile.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPreview(int streamType, Surface surface, boolean showPerson) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(showPerson ? 1 : 0);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPreview(int streamType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String setupImageTransferSocket(int streamType, int transferType) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(transferType);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopImageTransfer(int streamType, int transferType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(transferType);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addFindPersonHandler(FindPersonsHandler handler) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(handler != null ? handler.asBinder() : null);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void startPersonDetection() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void stopPersonDetection() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPersonTracking(int personId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(personId);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPersonTracking(int personId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(personId);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Person> findPersons() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(Person.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loadRecognitionDatabase(String database) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(database);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void saveRecognitionDatabase(String database) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(database);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getAprSenseTimeStamp() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIMUDataCallback(IIMUDataCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public void removeIMUDataCallback() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BaseFrameInfo getFrame(int streamType, int resolution, int pixelFormat) throws RemoteException {
                BaseFrameInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(resolution);
                    _data.writeInt(pixelFormat);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (BaseFrameInfo)BaseFrameInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BaseFrameInfo getFrameMemoryFile(int streamType, int resolution, int pixelFormat) throws RemoteException {
                BaseFrameInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(resolution);
                    _data.writeInt(pixelFormat);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (BaseFrameInfo)BaseFrameInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor setupImageTransferSharedMemory(int streamType, int transferType) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(streamType);
                    _data.writeInt(transferType);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParcelFileDescriptor)ParcelFileDescriptor.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getFloatParam(int paramID) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(paramID);
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] getCalibrationData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Version getVersion() throws RemoteException {
                Version _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Version)Version.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }
}

