package com.segway.robot.sdk.vision.internal.frame;

import android.util.SparseArray;

import java.nio.ByteBuffer;
import java.util.Stack;

/**
 * Recyclable frame
 */
public class RecyclableFrame extends BaseFrame {
    static SparseArray<Stack<RecyclableFrame>> mFramePool = new SparseArray<>();
    ByteBuffer mByteBuffer;
    BaseFrameInfo mBaseFrameInfo;
    private int mBufferSize;

    private RecyclableFrame (int bufferSize, BaseFrameInfo baseFrameInfo) {
        super();
        mBufferSize = bufferSize;
        mBaseFrameInfo = baseFrameInfo;
        mByteBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public void reuse(BaseFrameInfo baseFrameInfo) {
        super.reuse();
        mBaseFrameInfo = baseFrameInfo;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        mByteBuffer.rewind();
        return mByteBuffer;
    }

    @Override
    public BaseFrameInfo getInfo() {
        return mBaseFrameInfo;
    }

    @Override
    public void release() {
        synchronized (RecyclableFrame.class) {
            super.release();
            mFramePool.get(mBufferSize).push(this);
        }
    }

    public synchronized static RecyclableFrame create(int bufferSize, BaseFrameInfo baseFrameInfo) {
        if (mFramePool.get(bufferSize) == null) {
            mFramePool.put(bufferSize, new Stack());
        }

        if (mFramePool.get(bufferSize).empty()) {
            return new RecyclableFrame(bufferSize, baseFrameInfo);
        }

        RecyclableFrame recyclableFrame = mFramePool.get(bufferSize).pop();
        recyclableFrame.reuse(baseFrameInfo);
        return recyclableFrame;
    }
}
