package com.segway.robot.sdk.vision.internal.frame;

/**
 * Fish eye frame information
 */
public class FishEyeFrameInfo {
    BaseFrameInfo baseFrameInfo;

    public FishEyeFrameInfo(int streamType, int resolution, int pixelFormat,
                            int stride, int frameNum, int exposure, long timeStamp) {
        baseFrameInfo = new BaseFrameInfo(streamType, resolution, pixelFormat);
        baseFrameInfo.intArg0 = stride;
        baseFrameInfo.intArg1 = frameNum;
        baseFrameInfo.intArg2 = exposure;
        baseFrameInfo.longArg0 = timeStamp;
    }

    public FishEyeFrameInfo(BaseFrameInfo baseFrameInfo) {
        this.baseFrameInfo = baseFrameInfo;
    }

    public int getStride() {
        return baseFrameInfo.intArg0;
    }

    public int getFrameNum() {
        return baseFrameInfo.intArg1;
    }

    public int getExposure() {
        return baseFrameInfo.intArg2;
    }

    public long getTimeStamp() {
        return baseFrameInfo.longArg0;
    }

    public void setTimeStamp(long timeStamp) {
        baseFrameInfo.longArg0 = timeStamp;
    }

    public BaseFrameInfo getBaseFrameInfo() {
        return baseFrameInfo;
    }
}
