package com.segway.robot.sdk.vision.internal.frame;

/**
 * Depth frame information
 */
public class DepthFrameInfo {
    BaseFrameInfo baseFrameInfo;

    public DepthFrameInfo(int streamType, int resolution, int pixelFormat,
                          int stride, int frameNum, long timeStamp) {
        baseFrameInfo = new BaseFrameInfo(streamType, resolution, pixelFormat);
        baseFrameInfo.intArg0 = stride;
        baseFrameInfo.intArg1 = frameNum;
        baseFrameInfo.longArg0 = timeStamp;
    }

    public DepthFrameInfo(BaseFrameInfo baseFrameInfo) {
        this.baseFrameInfo = baseFrameInfo;
    }

    public int getStride() {
        return baseFrameInfo.intArg0;
    }

    public int getFrameNum() {
        return baseFrameInfo.intArg1;
    }

    public long getTimeStamp() {
        return baseFrameInfo.longArg0;
    }

    public void setTimeStamp(long timeStamp) {
        baseFrameInfo.longArg0 = timeStamp;
    }

    public BaseFrameInfo getBaseFrameInfo() {
        return baseFrameInfo;
    }
}
