package com.segway.robot.sdk.vision;

import com.segway.robot.sdk.vision.internal.frame.BaseFrameInfo;

import java.nio.ByteBuffer;

/**
 * Created by ark338 on 16/6/22.
 */
public interface Frame {
    /**
     * get Tid of current frame
     * @return Tid in long
     */
    long getTid();

    /**
     * get ByteBuffer of this Frame
     * @return ByteBuffer instance
     */
    ByteBuffer getByteBuffer();

    /**
     * get BaseFrameInfo of this Frame
     * @return BaseFrameInfo instance
     */
    BaseFrameInfo getInfo();
}
